@extends('layouts.employee')

@section('content')

    <div class="min-h-screen bg-gradient-to-br from-amber-50 to-white py-8">

        <div class="max-w-4xl mx-auto bg-white border border-amber-200 rounded-lg">

            <!-- Header -->
            <div class="px-6 py-4 border-b border-amber-200 flex items-center justify-between
                        bg-gradient-to-r from-amber-100 to-amber-50">
                <div>
                    <h2 class="text-base font-semibold text-amber-900">
                        Leave Applications
                    </h2>
                    <p class="text-sm text-amber-700">
                        View and manage your leave applications
                    </p>
                </div>
            </div>

            <!-- TABLE -->
            <div class="overflow-x-auto">
                <table class="w-full text-sm">
                    <thead class="bg-amber-50 text-amber-800">
                        <tr>
                            <th class="px-6 py-3 text-left">From</th>
                            <th class="px-6 py-3 text-left">To</th>
                            <th class="px-6 py-3 text-left">Days</th>
                            <th class="px-6 py-3 text-left">Status</th>
                            <th class="px-6 py-3 text-left">Applied On</th>
                        </tr>
                    </thead>

                    <tbody class="divide-y">
                        @forelse($leaves as $leave)
                            <tr class="hover:bg-amber-50">

                                <td class="px-6 py-4">
                                    {{ \Carbon\Carbon::parse($leave->start_date)->format('d M Y') }}
                                </td>
                                <td class="px-6 py-4">
                                    {{ \Carbon\Carbon::parse($leave->end_date)->format('d M Y') }}
                                </td>
                                <td class="px-6 py-4">
                                    {{ $leave->total_days }}
                                </td>
                                <td class="px-6 py-4">
                                    <span class="px-3 py-1 text-xs rounded-full
                                            @if($leave->status === 'approved') bg-green-100 text-green-700
                                            @elseif($leave->status === 'rejected') bg-red-100 text-red-700
                                            @else bg-yellow-100 text-yellow-700
                                            @endif">
                                        {{ ucfirst($leave->status) }}
                                    </span>
                                    @if($leave->admin_remark)
                                        <div class="text-[10px] text-gray-500 mt-1 max-w-[150px] truncate"
                                            title="{{ $leave->admin_remark }}">
                                            {{ $leave->admin_remark }}
                                        </div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-gray-600">
                                    {{ $leave->created_at->format('d M Y') }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-6 text-center text-gray-500">
                                    No leave applications found
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

        </div>
    </div>

@endsection