@php
    $active = "bg-[color:var(--emp-brand-soft)] text-[color:var(--emp-brand)] border border-[color:var(--emp-brand)]/40 shadow-sm";
    $idle = "text-[color:var(--emp-text)] hover:bg-[color:var(--emp-bg-soft)] border border-transparent hover:border-[color:var(--emp-border)]";
@endphp

<div class="mb-3 px-2">
    <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.18em]">
        Employee Panel
    </div>
</div>

<nav class="space-y-1">

    {{-- Dashboard --}}
    <a href="{{ route('employee.dashboard') }}"
        class="flex items-center gap-2 px-3 py-2.5 rounded-xl text-xs md:text-sm font-medium {{ request()->routeIs('employee.dashboard') ? $active : $idle }}">
        <span class="inline-flex h-7 w-7 items-center justify-center rounded-xl bg-[color:var(--emp-bg-soft)]">
            🏠
        </span>
        <span>Dashboard</span>
    </a>

    {{-- Add Conveyance --}}
    <a href="{{ route('employee.conveyance.create') }}"
        class="flex items-center gap-2 px-3 py-2.5 rounded-xl text-xs md:text-sm font-medium {{ request()->routeIs('employee.conveyance.create') ? $active : $idle }}">
        <span class="inline-flex h-7 w-7 items-center justify-center rounded-xl bg-[color:var(--emp-bg-soft)]">
            ➕
        </span>
        <span>Add Conveyance</span>
    </a>

    {{-- My Conveyance History (placeholder for now) --}}
    <a href="#"
        class="flex items-center gap-2 px-3 py-2.5 rounded-xl text-xs md:text-sm font-medium {{ request()->routeIs('employee.conveyance.history') ? $active : $idle }}">
        <span class="inline-flex h-7 w-7 items-center justify-center rounded-xl bg-[color:var(--emp-bg-soft)]">
            📅
        </span>
        <span>My Monthly Claims</span>
    </a>

    {{-- My Leaves --}}
    <a href="{{ route('employee.leaves.index') }}"
        class="flex items-center gap-2 px-3 py-2.5 rounded-xl text-xs md:text-sm font-medium {{ request()->routeIs('employee.leaves.*') ? $active : $idle }}">
        <span class="inline-flex h-7 w-7 items-center justify-center rounded-xl bg-[color:var(--emp-bg-soft)]">
            📝
        </span>
        <span>My Leaves</span>
    </a>

    {{-- Profile (optional future) --}}
    <a href="#"
        class="flex items-center gap-2 px-3 py-2.5 rounded-xl text-xs md:text-sm font-medium {{ request()->routeIs('employee.profile') ? $active : $idle }}">
        <span class="inline-flex h-7 w-7 items-center justify-center rounded-xl bg-[color:var(--emp-bg-soft)]">
            👤
        </span>
        <span>My Profile</span>
    </a>

</nav>

<div class="mt-4 p-3 rounded-2xl bg-[color:var(--emp-bg-soft)] border border-[color:var(--emp-border)]">
    <div class="text-[11px] font-semibold text-[color:var(--emp-text)] mb-1">
        Tip
    </div>
    <div class="text-[11px] text-[color:var(--emp-muted)]">
        Add your conveyance daily or weekly. Entries are allowed till the 10th of next month before approval.
    </div>
</div>