<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name', 'PAC Technology') }} | Admin</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        :root{
            /* APP SHELL */
            --bg: #F3F6FC;          /* page background */
            --bg-2: #E9EFFA;        /* subtle alt bg */
            --surface: #FFFFFF;     /* cards, nav, sidebar */
            --border: #E2E8F5;      /* soft border */

            /* BRAND */
            --brand: #2563EB;       /* primary blue */
            --brand-soft: #E0EAFF;  /* soft pill blue */
            --brand-dark: #1D4ED8;
            --accent: #F97316;      /* accent orange */

            /* TEXT */
            --text: #111827;
            --muted: #6B7280;
        }

        html {
            scroll-behavior: smooth;
        }
    </style>
</head>

<body class="min-h-screen text-[color:var(--text)] bg-[color:var(--bg)] overflow-x-hidden">

    {{-- TOP BAR (FULL WIDTH) --}}
    <header class="sticky top-0 z-30 bg-[color:var(--surface)] border-b border-[color:var(--border)]">
        <div class="px-6 py-3 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="h-10 w-10 rounded-2xl bg-[color:var(--brand)] grid place-items-center text-white font-extrabold shadow-md">
                    P
                </div>
                <div>
                    <div class="text-base font-extrabold tracking-tight">
                        PAC Technology – Admin
                    </div>
                    <div class="text-[11px] text-[color:var(--muted)]">
                        @yield('page-title', 'Employee Master')
                    </div>
                </div>
            </div>

            <div class="flex items-center gap-3">
                <div class="px-3 py-1.5 rounded-xl bg-[color:var(--bg-2)] border border-[color:var(--border)]
                            text-[11px] flex items-center gap-2">
                    <span class="inline-flex h-2 w-2 rounded-full bg-emerald-500"></span>
                    <span class="uppercase tracking-wide text-[10px] text-[color:var(--muted)]">Active Session</span>
                    <span class="font-semibold text-xs text-[color:var(--text)]">
                        {{ \App\Models\Session::active()?->name ?? 'Not Set' }}
                    </span>
                </div>

                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button class="px-4 py-2 rounded-xl bg-[color:var(--brand)] text-white text-xs font-semibold hover:bg-[color:var(--brand-dark)] transition shadow-sm">
                        Logout
                    </button>
                </form>
            </div>
        </div>
    </header>

    {{-- CONTENT --}}
    <main class="w-full max-w-[1480px] mx-auto px-4 lg:px-6 pb-10 pt-4">

        {{-- Alerts --}}
        <div class="space-y-3 mb-3">
            @if(session('success'))
                <div class="p-3 rounded-2xl bg-emerald-50 text-emerald-800 border border-emerald-200 shadow-sm text-sm">
                    {{ session('success') }}
                </div>
            @endif

            @if(isset($errors) && $errors->any())
                <div class="p-3 rounded-2xl bg-rose-50 text-rose-800 border border-rose-200 shadow-sm text-sm">
                    <ul class="list-disc ml-5 space-y-0.5">
                        @foreach($errors->all() as $err)
                            <li>{{ $err }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>

        @yield('content')
        @yield('scripts')
    </main>

</body>
</html>
