<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>{{ config('app.name', 'PAC Technology') }}</title>
  @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="min-h-screen text-slate-800 bg-slate-50">

  {{-- Topbar --}}
  <nav class="sticky top-0 z-50 bg-white/80 backdrop-blur border-b border-slate-200">
    <div class="max-w-6xl mx-auto px-4 py-3 flex items-center justify-between">
      <div class="flex items-center gap-2">
        <div class="h-9 w-9 rounded-xl bg-gradient-to-br from-blue-600 to-emerald-500 grid place-items-center text-white font-bold">
          P
        </div>
        <div>
          <div class="font-extrabold text-lg leading-none">PAC Technology</div>
          <div class="text-xs text-slate-500">Employee Conveyance System</div>
        </div>
      </div>

      @auth
      <form method="POST" action="{{ route('logout') }}">
        @csrf
        <button
          class="px-4 py-2 rounded-xl bg-rose-600 text-white text-sm font-semibold hover:bg-rose-700 transition shadow-sm">
          Logout
        </button>
      </form>
      @endauth
    </div>
  </nav>

  {{-- Alerts --}}
  <div class="max-w-6xl mx-auto p-4">
    @if(session('success'))
      <div class="mb-4 p-3 rounded-xl bg-emerald-50 text-emerald-800 border border-emerald-200 shadow-sm">
        {{ session('success') }}
      </div>
    @endif

    @if(isset($errors) && $errors->any())
      <div class="mb-4 p-3 rounded-xl bg-rose-50 text-rose-800 border border-rose-200 shadow-sm">
        <ul class="list-disc ml-5 text-sm">
          @foreach($errors->all() as $err)
            <li>{{ $err }}</li>
          @endforeach
        </ul>
      </div>
    @endif
  </div>

  {{-- Page Content --}}
  <main class="max-w-6xl mx-auto px-4 pb-10">
    @yield('content')
  </main>

  {{-- Footer --}}
  <footer class="border-t bg-white">
    <div class="max-w-6xl mx-auto px-4 py-4 text-xs text-slate-500 flex justify-between">
      <span>© {{ date('Y') }} PAC Technology</span>
      <span>Secure OTP Login</span>
    </div>
  </footer>

</body>
</html>
