<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>{{ $title ?? 'Authentication' }} - {{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

        <!-- Styles / Scripts -->
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
            <style>
                /*! tailwindcss v4.0.7 | MIT License | https://tailwindcss.com */
            </style>
        @endif

        <script>
            // Dark mode toggle
            document.addEventListener('DOMContentLoaded', function() {
                const darkMode = localStorage.getItem('darkMode') === 'true';
                if (darkMode) {
                    document.documentElement.classList.add('dark');
                }
            });

            function toggleDarkMode() {
                const isDark = document.documentElement.classList.toggle('dark');
                localStorage.setItem('darkMode', isDark);
            }

            function switchAuthMethod(method) {
                document.getElementById('email-auth').classList.add('hidden');
                document.getElementById('phone-auth').classList.add('hidden');
                document.getElementById(method + '-auth').classList.remove('hidden');
            }
        </script>
    </head>
    <body class="bg-gradient-to-br from-slate-50 to-slate-100 dark:from-slate-900 dark:to-slate-800 text-slate-900 dark:text-slate-50 min-h-screen flex flex-col">
        <!-- Header -->
        <header class="flex items-center justify-between p-6 lg:p-8">
            <div class="flex items-center gap-2">
                <div class="w-10 h-10 bg-gradient-to-br from-orange-500 to-red-600 rounded-lg flex items-center justify-center">
                    <span class="text-white font-bold text-lg">P</span>
                </div>
                <span class="text-xl font-semibold hidden sm:inline">PAC Tech</span>
            </div>
            <button 
                onclick="toggleDarkMode()" 
                class="p-2 hover:bg-slate-200 dark:hover:bg-slate-700 rounded-lg transition-colors"
                aria-label="Toggle dark mode"
            >
                <svg id="sun-icon" class="w-6 h-6 block dark:hidden" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l-2.12-2.12a4 4 0 00-5.656 0 4 4 0 005.656 5.656l2.12-2.12A6 6 0 0014.464 12.95zM16.05 5.464l-2.12 2.12A6 6 0 005.464 16.05l2.12-2.12A4 4 0 0016.05 5.464z" clip-rule="evenodd" />
                </svg>
                <svg id="moon-icon" class="w-6 h-6 hidden dark:block" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z" />
                </svg>
            </button>
        </header>

        <!-- Main Content -->
        <div class="flex-1 flex items-center justify-center px-4 py-8 lg:py-0">
            @yield('content')
        </div>
    </body>
</html>
