<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name', 'PAC Technology') }} | Employee</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <style>
        :root{
            --emp-bg: #F4F7FB;
            --emp-bg-soft: #EEF2F9;
            --emp-surface: #FFFFFF;
            --emp-border: #E0E6F2;
            --emp-text: #0F172A;
            --emp-muted: #64748B;
            --emp-brand: #2563EB; /* blue-600-ish */
        }
    </style>
</head>

<body class="min-h-screen bg-[color:var(--emp-bg)] text-[color:var(--emp-text)]">

{{-- Topbar --}}
<nav class="sticky top-0 z-40 bg-white/80 backdrop-blur border-b border-[color:var(--emp-border)]">
    <div class="max-w-6xl mx-auto px-4 py-3 flex items-center justify-between gap-3">
        <div class="flex items-center gap-2">
            <div class="h-9 w-9 rounded-xl bg-gradient-to-br from-blue-600 to-emerald-500 grid place-items-center text-white font-bold">
                P
            </div>
            <div>
                <div class="font-extrabold text-base leading-none">PAC Technology</div>
                <div class="text-[11px] text-[color:var(--emp-muted)]">Employee Conveyance System</div>
            </div>
        </div>

        @auth
            <div class="hidden sm:flex flex-col items-end">
                <div class="text-xs font-medium truncate max-w-[180px]">
                    {{ auth()->user()->email }}
                </div>
                <div class="text-[11px] text-[color:var(--emp-muted)]">Employee</div>
            </div>

            <form method="POST" action="{{ route('logout') }}" class="ml-2">
                @csrf
                <button
                    class="px-3 sm:px-4 py-2 rounded-xl bg-rose-600 text-white text-xs sm:text-sm font-semibold hover:bg-rose-700 transition shadow-sm">
                    Logout
                </button>
            </form>
        @endauth
    </div>
</nav>

<div class="max-w-6xl mx-auto px-4 pt-4">

    {{-- Alerts --}}
    @if(session('success'))
        <div class="mb-3 p-3 rounded-xl bg-emerald-50 text-emerald-800 border border-emerald-200 text-sm shadow-sm">
            {{ session('success') }}
        </div>
    @endif

    @if(isset($errors) && $errors->any())
        <div class="mb-3 p-3 rounded-xl bg-rose-50 text-rose-800 border border-rose-200 text-sm shadow-sm">
            <ul class="list-disc ml-5">
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- Employee Nav (Tabs / Buttons) --}}
    @auth
        @php
            $tabBase = 'inline-flex items-center justify-center px-3 sm:px-4 py-2 rounded-xl text-[11px] sm:text-xs font-semibold transition border';
            $tabIdle = $tabBase.' bg-white border-[color:var(--emp-border)] text-[color:var(--emp-muted)] hover:bg-slate-50';
            $tabActive = $tabBase.' bg-[color:var(--emp-brand)] border-[color:var(--emp-brand)] text-white shadow-sm';
        @endphp

        <nav class="mb-4">
    <div class="inline-flex flex-wrap gap-2 bg-[color:var(--emp-bg-soft)] border border-[color:var(--emp-border)] rounded-2xl p-1.5">

        <a href="{{ route('employee.dashboard') }}"
           class="{{ request()->routeIs('employee.dashboard') ? $tabActive : $tabIdle }}">
            <span class="hidden sm:inline mr-1">🏠</span> Dashboard
        </a>

        <a href="{{ route('employee.conveyance.create') }}"
           class="{{ request()->routeIs('employee.conveyance.create') ? $tabActive : $tabIdle }}">
            <span class="hidden sm:inline mr-1">➕</span> Add Conveyance
        </a>

        <a href="{{ route('employee.conveyance.index') }}"
           class="{{ request()->routeIs('employee.conveyance.index') ? $tabActive : $tabIdle }}">
            <span class="hidden sm:inline mr-1">📋</span> My Conveyance
        </a>

        <a href="{{ route('employee.expenses.create') }}"
           class="{{ request()->routeIs('employee.expenses.create') ? $tabActive : $tabIdle }}">
            <span class="hidden sm:inline mr-1">➕</span> Add Expense
        </a>

        <a href="{{ route('employee.expenses.index') }}"
           class="{{ request()->routeIs('employee.expenses.index') ? $tabActive : $tabIdle }}">
            <span class="hidden sm:inline mr-1">📁</span> My Expenses
        </a>

        {{-- ⭐ NEW TAB: EXPENSE GROUPS --}}
        <a href="{{ route('employee.expense-groups.index') }}"
           class="{{ request()->routeIs('employee.expense-groups.*') ? $tabActive : $tabIdle }}">
            <span class="hidden sm:inline mr-1">🗂</span> Expense Groups
        </a>

         <a href="{{ route('employee.leaves.create') }}"
   class="relative flex items-center gap-2 px-3 py-1.5
          rounded-md font-medium text-sm
          text-slate-900
          bg-gradient-to-r from-amber-50 to-white
          border border-amber-200
          hover:bg-amber-100
          transition">

    <!-- Accent strip -->
    <span class="absolute left-0 top-0 h-full w-0.5 rounded-l-md bg-amber-500"></span>

    <span class="hidden sm:inline text-amber-600 text-base">🗓️</span>
    <span>Apply Leave</span>

    <!-- NEW badge -->
    <span class="ml-auto text-[10px] font-semibold uppercase tracking-wide
                 text-amber-700 bg-amber-100 px-1.5 py-0.5 rounded
                 animate-pulse">
        New
    </span>
</a>


    </div>
</nav>

    @endauth
</div>

{{-- Page Content --}}
<main class="max-w-6xl mx-auto px-4 pb-10 pt-1">
    @yield('content')
</main>

<footer class="border-t border-[color:var(--emp-border)] bg-white">
    <div class="max-w-6xl mx-auto px-4 py-4 text-[11px] text-[color:var(--emp-muted)] flex justify-between">
        <span>© {{ date('Y') }} PAC Technology</span>
        <span>Secure OTP Login</span>
    </div>
</footer>

</body>
</html>
