<?php

use App\Http\Controllers\Auth\OtpAuthController;
use App\Http\Controllers\Admin\AdminSessionController;
use App\Http\Controllers\Admin\AdminEmployeeController;
use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Admin\ClientController;
use App\Http\Controllers\Employee\ConveyanceController;
use App\Http\Controllers\Employee\DashboardController as EmployeeDashboardController;
use App\Http\Controllers\Admin\AdminConveyanceReportController;
use App\Http\Controllers\Admin\ClientRequestController as AdminClientRequestController;
use App\Http\Controllers\Admin\EmployeeMonthReportController;
use App\Http\Controllers\Employee\ExpenseController;
use App\Http\Controllers\Employee\ExpenseGroupController;
use App\Http\Controllers\Admin\ExpenseReportController;
use App\Http\Controllers\Admin\EmployeeMonthlyConveyanceController;
use App\Http\Controllers\Employee\LeaveController;
use Illuminate\Support\Facades\Route;

Route::get('/', fn() => redirect()->route('login'));

// =====================
// OTP Auth
// =====================
Route::get('/login', [OtpAuthController::class, 'showLogin'])->name('login');
Route::post('/login/send-otp', [OtpAuthController::class, 'sendOtp'])->name('otp.send');
Route::get('/login/verify', [OtpAuthController::class, 'showVerifyForm'])->name('otp.verify.form');
Route::post('/login/verify', [OtpAuthController::class, 'verifyOtp'])->name('otp.verify');
Route::post('/logout', [OtpAuthController::class, 'logout'])->name('logout');

// =====================
// ADMIN ROUTES
// =====================
Route::middleware(['auth', 'admin'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {

        // Dashboard
        Route::get('/dashboard', [AdminDashboardController::class, 'index'])
            ->name('dashboard');

        // Financial Sessions
        Route::get('/sessions', [AdminSessionController::class, 'index'])->name('sessions.index');
        Route::get('/sessions/create', [AdminSessionController::class, 'create'])->name('sessions.create');
        Route::post('/sessions', [AdminSessionController::class, 'store'])->name('sessions.store');
        Route::post('/sessions/{id}/activate', [AdminSessionController::class, 'activate'])->name('sessions.activate');

        // Employees
        Route::get('/employees', [AdminEmployeeController::class, 'index'])->name('employees.index');
        Route::get('/employees/create', [AdminEmployeeController::class, 'create'])->name('employees.create');
        Route::post('/employees', [AdminEmployeeController::class, 'store'])->name('employees.store');
        Route::get('/employees/{employee}/edit', [AdminEmployeeController::class, 'edit'])->name('employees.edit');
        Route::put('/employees/{employee}', [AdminEmployeeController::class, 'update'])->name('employees.update');
        Route::delete('/employees/{employee}', [AdminEmployeeController::class, 'destroy'])->name('employees.destroy');
        Route::post('/employees/{id}/attach-session', [AdminEmployeeController::class, 'attachSession'])->name('employees.attachSession');

        // 🔁 Toggle active/inactive
        Route::patch('/employees/{employee}/toggle-active', [AdminEmployeeController::class, 'toggleActive'])->name('employees.toggle-active');
        // Client Master
        Route::get('/clients', [ClientController::class, 'index'])->name('clients.index');
        Route::get('/clients/create', [ClientController::class, 'create'])->name('clients.create');
        Route::post('/clients', [ClientController::class, 'store'])->name('clients.store');
        Route::patch('/clients/{client}/toggle', [ClientController::class, 'toggleStatus'])
            ->name('clients.toggle');

        // ============================
        // Conveyance reports (client-wise)
        // ============================
    
        // Main summary (with filters: session / from / to / client)
        Route::get('/conveyance/clients', [AdminConveyanceReportController::class, 'clientSummary'])
            ->name('conveyance.clients');

        // Export summary (MUST be before any {client} wildcard)
        Route::get('/conveyance/clients/export', [AdminConveyanceReportController::class, 'clientSummaryExport'])
            ->name('conveyance.clients.export');

        // Detail view: employees & entries for a specific client
        Route::get('/conveyance/clients/{client}/employees', [AdminConveyanceReportController::class, 'clientEmployees'])
            ->name('conveyance.clientEmployees');

        // EXPORT - Summary
        Route::get('/conveyance/clients/{client}/employees/export-summary', [AdminConveyanceReportController::class, 'clientEmployeesExportSummary'])
            ->name('conveyance.clientEmployees.exportSummary');

        // EXPORT - Detailed (Multi-sheet)
        Route::get('/conveyance/clients/{client}/employees/export-detailed', [AdminConveyanceReportController::class, 'clientEmployeesExportDetailed'])
            ->name('conveyance.clientEmployees.exportDetailed');

        // ============================
        // Client Requests from Employees
        // ============================
        Route::get('/client-requests', [AdminClientRequestController::class, 'index'])
            ->name('client-requests.index');

        Route::post('/client-requests/{clientRequest}/status', [AdminClientRequestController::class, 'updateStatus'])
            ->name('client-requests.updateStatus');

        // ============================
        // Employee Master (month-wise consolidated)
        // ============================
        Route::get('/conveyance/employee-master', [AdminConveyanceReportController::class, 'employeeMaster'])
            ->name('conveyance.employeeMaster');

        // Excel export for Employee Master
        Route::get('/conveyance/employee-master/export', [AdminConveyanceReportController::class, 'employeeMasterExport'])
            ->name('conveyance.employeeMaster.export');

        // ============================
        // Employee Month Report (summary + full)
        // ============================
        Route::get('/conveyance/employee-month-report', [EmployeeMonthReportController::class, 'index'])
            ->name('conveyance.employeeMonthReport');

        Route::get('/conveyance/employee-month-report/export-summary', [EmployeeMonthReportController::class, 'exportSummary'])
            ->name('conveyance.employeeMonthReport.exportSummary');

        Route::get('/conveyance/employee-month-report/export-full', [EmployeeMonthReportController::class, 'exportFull'])
            ->name('conveyance.employeeMonthReport.exportFull');

        // ============================
        // Expense Reports (Admin)
        // ============================
        Route::get('/expenses/report', [ExpenseReportController::class, 'index'])
            ->name('expenses.report');

        Route::get('/expenses/report/export', [ExpenseReportController::class, 'export'])
            ->name('expenses.report.export');


        Route::get('/reports/employee-monthly-conveyance', [EmployeeMonthlyConveyanceController::class, 'index'])->name('reports.employee-monthly-conveyance');

        Route::get('/reports/employee-monthly-conveyance/export', [EmployeeMonthlyConveyanceController::class, 'export'])->name('reports.employee-monthly-conveyance.export');

        Route::get('/expenses/{expense}/download', [\App\Http\Controllers\Admin\ExpenseReportController::class, 'downloadProof'])->name('expenses.download');

        // ============================
        // Leave Management
        // ============================
        Route::get('/leaves', [\App\Http\Controllers\Admin\AdminLeaveController::class, 'index'])->name('leaves.index');
        Route::post('/leaves/{leave}/status', [\App\Http\Controllers\Admin\AdminLeaveController::class, 'updateStatus'])->name('leaves.updateStatus');
    });

// =====================
// EMPLOYEE ROUTES
// =====================
Route::middleware(['auth'])
    ->prefix('employee')
    ->name('employee.')
    ->group(function () {

        // Dashboard
        Route::get('/dashboard', [EmployeeDashboardController::class, 'index'])
            ->name('dashboard');

        // Conveyance listing (Overview / Current Month)
        Route::get('/conveyance', [ConveyanceController::class, 'index'])
            ->name('conveyance.index');

        // History Listing
        Route::get('/conveyance/history', [ConveyanceController::class, 'history'])
            ->name('conveyance.history');

        // Detailed Month View
        Route::get('/conveyance/history/{month}', [ConveyanceController::class, 'showMonth'])
            ->name('conveyance.showMonth');

        // Add conveyance (sheet)
        Route::get('/conveyance/add', [ConveyanceController::class, 'create'])
            ->name('conveyance.create');

        Route::post('/conveyance', [ConveyanceController::class, 'store'])
            ->name('conveyance.store');

        // Edit / update / delete
        Route::get('/conveyance/{conveyance}/edit', [ConveyanceController::class, 'edit'])
            ->name('conveyance.edit');

        Route::put('/conveyance/{conveyance}', [ConveyanceController::class, 'update'])
            ->name('conveyance.update');

        Route::delete('/conveyance/{conveyance}', [ConveyanceController::class, 'destroy'])
            ->name('conveyance.destroy');

        // Employee → Request new client (goes to admin)
        Route::post('/client-requests', [ConveyanceController::class, 'storeClientRequest'])
            ->name('client-requests.store');


        Route::post('conveyance/{conveyance}/submit-row', [ConveyanceController::class, 'submitRow'])
            ->name('conveyance.submitRow');

        Route::post('conveyance/submit-all', [ConveyanceController::class, 'submitAllDraft'])
            ->name('conveyance.submitAll');

        // ============================
        // Expenses (Employee)
        // ============================
        Route::get('/expenses', [ExpenseController::class, 'index'])->name('expenses.index');
        Route::get('/expenses/create', [ExpenseController::class, 'create'])->name('expenses.create');
        Route::post('/expenses', [ExpenseController::class, 'store'])->name('expenses.store');
        Route::get('/expenses/{expense}', [ExpenseController::class, 'show'])->name('expenses.show');
        Route::get('/expenses/{expense}/download', [ExpenseController::class, 'downloadProof'])->name('expenses.download');
        Route::get('/expenses/{expense}/edit', [ExpenseController::class, 'edit'])->name('expenses.edit');
        Route::put('/expenses/{expense}', [ExpenseController::class, 'update'])->name('expenses.update');
        Route::delete('/expenses/{expense}', [ExpenseController::class, 'destroy'])->name('expenses.destroy');

        // Expense Groups (for dropdown in Add Expense)
        Route::post('/expense-groups', [ExpenseGroupController::class, 'store'])->name('expense-groups.store');
        Route::get('/expense-groups', [ExpenseGroupController::class, 'index'])->name('expense-groups.index');



        //routes for leaves
        Route::get('/leaves', [LeaveController::class, 'index'])->name('leaves.index');
        Route::get('/leaves/create', [LeaveController::class, 'create'])->name('leaves.create');
        Route::post('/leaves/store', [LeaveController::class, 'store'])->name('leaves.store');
    });
