

<?php $__env->startSection('page-title', $currentMonthLabel . ' History'); ?>
<?php $__env->startSection('page-subtitle', 'Verified claim details'); ?>

<?php $__env->startSection('content'); ?>

    <style>
        /* Shared Table Styles */
        thead th {
            position: sticky;
            top: 0;
            z-index: 10;
            background-color: #f3f4f6;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
        }

        tbody tr:nth-child(even) {
            background-color: #f9fafb;
        }

        tbody tr:hover {
            background-color: #f0f9ff;
        }
    </style>

    <div class="mb-6">
        <div class="flex items-center justify-between mb-4">
            <div>
                <h1 class="text-xl font-bold text-gray-900"><?php echo e($currentMonthLabel); ?> Report</h1>
                <p class="text-sm text-gray-500">
                    Verified submission for <?php echo e($monthStart->format('F Y')); ?>

                </p>
            </div>
            <a href="<?php echo e(route('employee.conveyance.history')); ?>"
                class="px-3 py-1.5 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded hover:bg-gray-50 transition shadow-sm">
                ← Back to History
            </a>
        </div>

        <!-- Summary Cards -->
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-4">
            <div class="bg-indigo-50 border border-indigo-100 rounded-lg p-3">
                <div class="text-xs font-semibold text-indigo-800 uppercase">Total Amount</div>
                <div class="text-lg font-bold text-indigo-900 mt-1">₹<?php echo e(number_format($monthTotalSubmitted)); ?></div>
            </div>
            <div class="bg-white border border-gray-200 rounded-lg p-3">
                <div class="text-xs font-semibold text-gray-500 uppercase">Entries</div>
                <div class="text-lg font-bold text-gray-900 mt-1"><?php echo e($conveyances->count()); ?></div>
            </div>
        </div>
    </div>

    <!-- Main Table (Enterprise Style) -->
    <div class="bg-white border border-gray-300 rounded-lg shadow-sm overflow-hidden">
        <div class="max-h-[600px] overflow-auto">
            <table class="w-full text-left border-collapse text-sm">
                <thead>
                    <tr class="text-xs text-gray-700 uppercase tracking-wide border-b border-gray-300">
                        <th class="p-3 border-r border-gray-300 text-center w-24">Date</th>
                        <th class="p-3 border-r border-gray-300 w-1/4">Route</th>
                        <th class="p-3 border-r border-gray-300 w-1/4">Client / Remarks</th>
                        <th class="p-3 border-r border-gray-300 w-24 text-center">Mode</th>
                        <th class="p-3 border-r border-gray-300 w-32 text-right">Amount</th>
                        <th class="p-3 text-center w-24">Return</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $conveyances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $rowTotal = $c->total_amount;
                            $isSunday = $c->date->isSunday();
                        ?>
                        <tr class="<?php echo e($isSunday ? 'bg-orange-50' : ''); ?>">
                            <td class="p-3 border-r border-gray-200 text-center">
                                <span class="block font-bold text-gray-900"><?php echo e($c->date->format('d')); ?></span>
                                <span class="block text-xs uppercase text-gray-500"><?php echo e($c->date->format('D')); ?></span>
                            </td>
                            <td class="p-3 border-r border-gray-200">
                                <div class="flex items-center gap-1.5 text-gray-900 font-medium">
                                    <?php echo e($c->from_location); ?>

                                    <span class="text-gray-400">→</span>
                                    <?php echo e($c->to_location); ?>

                                </div>
                            </td>
                            <td class="p-3 border-r border-gray-200">
                                <?php if($c->client): ?>
                                    <div class="font-semibold text-indigo-900 text-xs"><?php echo e($c->client->name); ?></div>
                                <?php endif; ?>
                                <?php if($c->remarks): ?>
                                    <div class="text-gray-500 text-xs mt-0.5"><?php echo e($c->remarks); ?></div>
                                <?php endif; ?>
                            </td>
                            <td class="p-3 border-r border-gray-200 text-center text-xs">
                                <span class="px-1.5 py-0.5 rounded border border-gray-200 bg-gray-50">
                                    <?php echo e($c->mode); ?>

                                </span>
                            </td>
                            <td class="p-3 border-r border-gray-200 text-right font-mono font-bold text-gray-900">
                                ₹<?php echo e(number_format($rowTotal, 2)); ?>

                            </td>
                            <td class="p-3 text-center">
                                <?php if($c->is_return): ?>
                                    <span class="text-emerald-600 font-bold text-xs">Yes</span>
                                    <?php if($c->return_amount): ?>
                                        <div class="text-[10px] text-gray-400">(₹<?php echo e($c->return_amount); ?>)</div>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-gray-300">-</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="p-8 text-center text-gray-500">
                                No records found for this period.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                <?php if($conveyances->isEmpty() === false): ?>
                    <tfoot class="bg-gray-50 border-t border-gray-300">
                        <tr>
                            <td colspan="4" class="p-3 text-right font-bold text-gray-700 uppercase text-xs">Total Claimed</td>
                            <td class="p-3 text-right font-bold text-lg text-emerald-700 border-l border-gray-300">
                                ₹<?php echo e(number_format($monthTotalSubmitted, 2)); ?>

                            </td>
                            <td></td>
                        </tr>
                    </tfoot>
                <?php endif; ?>
            </table>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\softwares\26dec25Backup\resources\views/employee/conveyance/view.blade.php ENDPATH**/ ?>