<?php $__env->startSection('page-title', 'Dashboard'); ?>
<?php $__env->startSection('page-subtitle', 'Overview of your conveyance activity'); ?>

<?php $__env->startSection('content'); ?>

    <?php
        $today = now()->format('d M Y');
    ?>

    
    <div class="rounded-3xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-5 mb-5">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
            <div>
                <h2 class="text-xl md:text-2xl font-extrabold tracking-tight">
                    Welcome, <?php echo e(auth()->user()->name ?? 'Employee'); ?> 👋
                </h2>
                <p class="text-sm text-[color:var(--emp-muted)] mt-1">
                    Today is <span class="font-semibold text-[color:var(--emp-text)]"><?php echo e($today); ?></span>.
                    You are working in
                    <span class="font-semibold">
                        <?php echo e($currentMonthLabel ?? 'Current Month'); ?>

                    </span>
                    window (<?php echo e($monthStart->format('d M')); ?> – <?php echo e($monthEnd->format('d M Y')); ?>).
                </p>
                <?php if($activeSession): ?>
                    <p class="text-xs text-[color:var(--emp-muted)] mt-1">
                        Active Financial Session:
                        <span class="font-semibold text-[color:var(--emp-text)]"><?php echo e($activeSession->name); ?></span>
                    </p>
                <?php endif; ?>
            </div>

            <div class="flex gap-2 flex-wrap">
                <a href="<?php echo e(route('employee.conveyance.create')); ?>"
                    class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl bg-[color:var(--emp-brand)] text-white text-xs md:text-sm font-semibold hover:bg-blue-700 transition shadow-sm">
                    <span>➕</span> Add Conveyance
                </a>
                <a href="<?php echo e(route('employee.conveyance.index')); ?>"
                    class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl bg-[color:var(--emp-bg-soft)] text-[color:var(--emp-text)] text-xs md:text-sm font-semibold border border-[color:var(--emp-border)] hover:bg-slate-100 transition">
                    📋 View My Conveyance
                </a>
            </div>
        </div>
    </div>

    
    <?php if(isset($historySummary) && $historySummary->isNotEmpty()): ?>
        <div class="flex gap-2 overflow-x-auto pb-2 mb-4 scrollbar-hide">
            <?php $__currentLoopData = $historySummary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $summary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div
                    class="flex-shrink-0 px-3 py-1.5 rounded-lg bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] text-[11px] text-[color:var(--emp-muted)] whitespace-nowrap shadow-sm">
                    <span class="font-bold text-[color:var(--emp-text)]"><?php echo e($summary['month_label']); ?></span>
                    <span class="mx-1 text-slate-300">|</span>
                    Submitted: <span class="font-semibold text-emerald-600">₹ <?php echo e(number_format($summary['total'])); ?></span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    
    <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-4 mb-6">

        
        <div
            class="rounded-2xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-4 relative overflow-hidden">
            <div class="absolute top-0 left-0 right-0 h-1 bg-[color:var(--emp-brand)]"></div>
            <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.16em]">
                This Month (Submitted)
            </div>
            <div class="mt-2 text-2xl font-extrabold text-[color:var(--emp-text)]">
                ₹ <?php echo e(number_format($monthTotalSubmitted, 2)); ?>

            </div>
            <div class="mt-1 text-[11px] text-[color:var(--emp-muted)]">
                Total conveyance amount you have submitted in <?php echo e($currentMonthLabel); ?>.
            </div>
        </div>

        
        <div
            class="rounded-2xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-4 relative overflow-hidden">
            <div class="absolute top-0 left-0 right-0 h-1 bg-slate-500/80"></div>
            <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.16em]">
                Draft Entries
            </div>
            <div class="mt-2 text-2xl font-extrabold text-[color:var(--emp-text)]">
                ₹ <?php echo e(number_format($monthTotalDraft, 2)); ?>

            </div>
            <div class="mt-1 text-[11px] text-[color:var(--emp-muted)]">
                Amount saved as draft, not yet submitted for <?php echo e($currentMonthLabel); ?>.
            </div>
        </div>

        
        <div
            class="rounded-2xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-4 relative overflow-hidden">
            <div class="absolute top-0 left-0 right-0 h-1 bg-emerald-500/80"></div>
            <div class="text-[11px] font-semibold text-[color:var(--emp-muted)] uppercase tracking-[0.16em]">
                Claim Window
            </div>
            <div class="mt-2 text-base font-semibold text-[color:var(--emp-text)]">
                <?php echo e($monthStart->format('d M Y')); ?> – <?php echo e($monthEnd->format('d M Y')); ?>

            </div>
            <div class="mt-1 text-[11px] text-[color:var(--emp-muted)]">
                Entries allowed for this month, and editable till the 10th of next month.
            </div>
        </div>
    </div>

    
    <div class="grid lg:grid-cols-2 gap-4">

        <div class="rounded-2xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-4">
            <h3 class="text-sm font-semibold mb-2">Quick Actions</h3>
            <div class="space-y-2 text-sm">
                <a href="<?php echo e(route('employee.conveyance.create')); ?>"
                    class="block px-3 py-2 rounded-xl bg-[color:var(--emp-bg-soft)] hover:bg-slate-100 border border-[color:var(--emp-border)] font-semibold">
                    Add today&apos;s conveyance →
                </a>
                <a href="<?php echo e(route('employee.conveyance.index')); ?>"
                    class="block px-3 py-2 rounded-xl bg-white hover:bg-slate-50 border border-[color:var(--emp-border)] text-xs">
                    Review this month&apos;s entries →
                </a>
            </div>
        </div>

        <div class="rounded-2xl bg-[color:var(--emp-surface)] border border-[color:var(--emp-border)] shadow-sm p-4">
            <h3 class="text-sm font-semibold mb-2">Guidelines</h3>
            <ul class="text-xs text-[color:var(--emp-muted)] space-y-1.5">
                <li>• Add travel entries daily or at least once a week.</li>
                <li>• Only dates from current month (<?php echo e($currentMonthLabel); ?>) are allowed in this sheet.</li>
                <li>• Editing is open till the 10th of next month for draft entries.</li>
                <li>• For round trips, use the “Return trip” checkbox while adding entries.</li>
            </ul>
        </div>

    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\softwares\26dec25Backup\resources\views/employee/dashboard.blade.php ENDPATH**/ ?>