


<?php $__env->startSection('content'); ?>
    <div class="min-h-screen bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
            
            <div class="mb-6 flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">Expense Ledger</h1>
                    <p class="text-sm text-gray-600 mt-1">Manage and track your expense claims</p>
                </div>
                <div class="flex items-center gap-2">
                    <a href="<?php echo e(route('employee.expenses.create')); ?>"
                        class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 focus:bg-blue-700 active:bg-blue-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                        </svg>
                        New Expense
                    </a>
                </div>
            </div>

            
            <div id="pageBanner" class="mb-4 hidden max-w-3xl"></div>

            
            <div class="bg-white shadow-sm rounded-lg border border-gray-200 overflow-hidden">
                
                <div class="hidden md:block bg-gray-50 border-b border-gray-200 px-6 py-3">
                    <div class="grid grid-cols-12 gap-4 text-xs font-semibold text-gray-700 uppercase tracking-wider">
                        <div class="col-span-2">Date</div>
                        <div class="col-span-2">Group</div>
                        <div class="col-span-2">Party Name</div>
                        <div class="col-span-3">Purpose</div>
                        <div class="col-span-1 text-right">Amount</div>
                        <div class="col-span-1 text-center">Receipt</div>
                        <div class="col-span-1 text-center">Actions</div>
                    </div>
                </div>

                
                <div class="divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $files = [];
                            if (!empty($expense->proof_paths) && is_array($expense->proof_paths)) {
                                $files = $expense->proof_paths;
                            } elseif (!empty($expense->proof_path)) {
                                $files = [['path' => $expense->proof_path, 'original_name' => $expense->proof_original_name]];
                            }
                        ?>

                        <div class="expense-row px-4 md:px-6 py-4 transition-all duration-200" data-id="<?php echo e($expense->id); ?>"
                            data-update-url="<?php echo e(route('employee.expenses.update', $expense->id)); ?>">
                            
                            <div class="hidden md:grid grid-cols-12 gap-4 items-center">
                                
                                <div class="col-span-2">
                                    <div class="view-mode">
                                        <div class="text-sm font-medium text-gray-900">
                                            <?php echo e($expense->expense_date->format('M j, Y')); ?>

                                        </div>
                                        <div class="text-xs text-gray-500">
                                            <?php echo e($expense->created_at->diffForHumans()); ?>

                                        </div>
                                    </div>
                                    <div class="edit-mode hidden">
                                        <input type="date" name="expense_date"
                                            value="<?php echo e($expense->expense_date->format('Y-m-d')); ?>"
                                            class="w-full text-sm border border-[color:var(--emp-border)] rounded-xl px-3 py-2 focus:outline-none focus:ring-2 focus:ring-[color:var(--emp-brand)]">
                                    </div>
                                </div>

                                
                                <div class="col-span-2">
                                    <div class="view-mode">
                                        <span
                                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                            <?php echo e($expense->group ?? 'General'); ?>

                                        </span>
                                    </div>
                                    <div class="edit-mode hidden">
                                        <input type="text" name="group" value="<?php echo e($expense->group ?? ''); ?>"
                                            class="w-full text-sm border border-[color:var(--emp-border)] rounded-xl px-3 py-2 focus:outline-none focus:ring-2 focus:ring-[color:var(--emp-brand)]"
                                            placeholder="Category">
                                    </div>
                                </div>

                                
                                <div class="col-span-2">
                                    <div class="view-mode text-sm text-gray-900">
                                        <?php echo e($expense->party_name ?? '-'); ?>

                                    </div>
                                    <div class="edit-mode hidden">
                                        <input type="text" name="party_name" value="<?php echo e($expense->party_name ?? ''); ?>"
                                            class="w-full text-sm border border-[color:var(--emp-border)] rounded-xl px-3 py-2 focus:outline-none focus:ring-2 focus:ring-[color:var(--emp-brand)]"
                                            placeholder="Vendor">
                                    </div>
                                </div>

                                
                                <div class="col-span-3">
                                    <div class="view-mode text-sm text-gray-900">
                                        <?php echo e($expense->purpose ?? '-'); ?>

                                    </div>
                                    <div class="edit-mode hidden">
                                        <input type="text" name="purpose" value="<?php echo e($expense->purpose ?? ''); ?>"
                                            class="w-full text-sm border border-[color:var(--emp-border)] rounded-xl px-3 py-2 focus:outline-none focus:ring-2 focus:ring-[color:var(--emp-brand)]"
                                            placeholder="Description">
                                    </div>
                                </div>

                                
                                <div class="col-span-1">
                                    <div class="view-mode text-right">
                                        <span class="text-sm font-semibold text-gray-900">
                                            ₹<?php echo e(number_format($expense->amount, 2)); ?>

                                        </span>
                                    </div>
                                    <div class="edit-mode hidden">
                                        <input type="number" name="amount" step="0.01" min="0" value="<?php echo e($expense->amount); ?>"
                                            class="w-full text-sm text-right border border-[color:var(--emp-border)] rounded-xl px-3 py-2 focus:outline-none focus:ring-2 focus:ring-[color:var(--emp-brand)]">
                                    </div>
                                </div>

                                
                                <div class="col-span-1">
                                    <div class="view-mode flex justify-center">
                                        <?php if(count($files)): ?>
                                            <div class="flex space-x-1">
                                                <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a href="<?php echo e(route('employee.expenses.download', $expense->id)); ?>?file=<?php echo e(urlencode($f['path'] ?? '')); ?>"
                                                        target="_blank" class="p-1 text-gray-400 hover:text-gray-600 transition-colors"
                                                        title="<?php echo e($f['original_name'] ?? basename($f['path'] ?? '')); ?>">
                                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                                        </svg>
                                                    </a>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-xs text-gray-400">No file</span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="edit-mode hidden">
                                        <div class="text-center">
                                            <input type="file" class="hidden file-input" name="add_files[]" multiple>
                                            <button type="button"
                                                class="attach-btn text-xs text-blue-600 hover:text-blue-800 font-medium">Attach
                                                Files</button>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="col-span-1">
                                    <div class="view-mode flex justify-center space-x-2">
                                        <button type="button"
                                            class="edit-btn p-1 text-gray-400 hover:text-blue-600 transition-colors"
                                            title="Edit">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                            </svg>
                                        </button>
                                        <form action="<?php echo e(route('employee.expenses.destroy', $expense->id)); ?>" method="POST"
                                            onsubmit="return confirm('Are you sure you want to delete this expense?');"
                                            class="inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="p-1 text-red-400 hover:text-red-600 transition-colors"
                                                title="Delete">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                </svg>
                                            </button>
                                        </form>
                                    </div>
                                    <div class="edit-mode hidden flex justify-center space-x-2">
                                        <button type="button"
                                            class="save-btn p-1 text-green-600 hover:text-green-800 transition-colors"
                                            title="Save">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M5 13l4 4L19 7" />
                                            </svg>
                                        </button>
                                        <button type="button"
                                            class="cancel-btn p-1 text-gray-600 hover:text-gray-800 transition-colors"
                                            title="Cancel">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M6 18L18 6M6 6l12 12" />
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="md:hidden grid grid-cols-1 gap-2">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <div class="text-sm font-medium text-gray-900">
                                            <?php echo e($expense->expense_date->format('M j, Y')); ?></div>
                                        <div class="text-xs text-gray-500"><?php echo e($expense->created_at->diffForHumans()); ?></div>
                                    </div>
                                    <div class="view-mode">
                                        <span
                                            class="text-sm font-semibold text-gray-900">₹<?php echo e(number_format($expense->amount, 2)); ?></span>
                                    </div>
                                </div>

                                <div class="mobile-card view-mode">
                                    <div class="text-sm text-gray-900"><?php echo e($expense->purpose ?? '-'); ?></div>
                                    <div class="text-xs text-gray-500 mt-1"><?php echo e($expense->party_name ?? '-'); ?></div>
                                    <div class="mt-2 flex items-center gap-2">
                                        <?php if(count($files)): ?>
                                            <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e(route('employee.expenses.download', $expense->id)); ?>?file=<?php echo e(urlencode($f['path'] ?? '')); ?>"
                                                    target="_blank"
                                                    class="text-xs px-2 py-1 rounded-md border bg-white hover:bg-slate-50">
                                                    <?php echo e(\Illuminate\Support\Str::limit($f['original_name'] ?? basename($f['path'] ?? ''), 20)); ?>

                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <span class="text-xs text-gray-400">No files</span>
                                        <?php endif; ?>
                                    </div>

                                    <div class="mt-3 flex justify-end gap-2">
                                        <button type="button"
                                            class="edit-btn p-1 text-gray-400 hover:text-blue-600 transition-colors"
                                            title="Edit">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                            </svg>
                                        </button>
                                        <form action="<?php echo e(route('employee.expenses.destroy', $expense->id)); ?>" method="POST"
                                            onsubmit="return confirm('Are you sure you want to delete this expense?');"
                                            class="inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="p-1 text-red-400 hover:text-red-600 transition-colors"
                                                title="Delete">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                </svg>
                                            </button>
                                        </form>
                                    </div>
                                </div>

                                
                                <div
                                    class="md:hidden edit-mode hidden bg-white p-3 rounded-lg border border-[color:var(--emp-border)]">
                                    <div class="grid grid-cols-1 gap-2">
                                        <div>
                                            <label class="text-xs font-medium mb-1 block">Date</label>
                                            <input type="date" name="expense_date"
                                                value="<?php echo e($expense->expense_date->format('Y-m-d')); ?>"
                                                class="w-full border border-[color:var(--emp-border)] rounded-xl px-3 py-2 text-sm">
                                        </div>
                                        <div>
                                            <label class="text-xs font-medium mb-1 block">Group</label>
                                            <input type="text" name="group" value="<?php echo e($expense->group ?? ''); ?>"
                                                class="w-full border border-[color:var(--emp-border)] rounded-xl px-3 py-2 text-sm">
                                        </div>
                                        <div>
                                            <label class="text-xs font-medium mb-1 block">Party Name</label>
                                            <input type="text" name="party_name" value="<?php echo e($expense->party_name ?? ''); ?>"
                                                class="w-full border border-[color:var(--emp-border)] rounded-xl px-3 py-2 text-sm">
                                        </div>
                                        <div>
                                            <label class="text-xs font-medium mb-1 block">Purpose</label>
                                            <input type="text" name="purpose" value="<?php echo e($expense->purpose ?? ''); ?>"
                                                class="w-full border border-[color:var(--emp-border)] rounded-xl px-3 py-2 text-sm">
                                        </div>
                                        <div>
                                            <label class="text-xs font-medium mb-1 block">Amount (₹)</label>
                                            <input type="number" name="amount" step="0.01" min="0"
                                                value="<?php echo e($expense->amount); ?>"
                                                class="w-full text-right border border-[color:var(--emp-border)] rounded-xl px-3 py-2 text-sm">
                                        </div>
                                        <div>
                                            <label class="text-xs font-medium mb-1 block">Attach files</label>
                                            <div class="flex items-center gap-2">
                                                <input type="file" class="hidden file-input" name="add_files[]" multiple>
                                                <button type="button"
                                                    class="attach-btn px-3 py-1.5 rounded-xl bg-white border text-sm">Attach</button>
                                                <div class="text-xs text-[color:var(--emp-muted)]"><?php if(count($files)): ?>
                                                <?php echo e(count($files)); ?> attached <?php else: ?> No files <?php endif; ?></div>
                                            </div>
                                        </div>
                                        <div class="flex justify-end gap-2 mt-2">
                                            <button type="button"
                                                class="save-btn px-3 py-2 rounded-xl bg-green-600 text-white text-sm">Save</button>
                                            <button type="button"
                                                class="cancel-btn px-3 py-2 rounded-xl border text-sm">Cancel</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="px-6 py-12 text-center">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                            </svg>
                            <h3 class="mt-2 text-sm font-medium text-gray-900">No expenses</h3>
                            <p class="mt-1 text-sm text-gray-500">Get started by creating a new expense.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            
            <?php if($expenses->hasPages()): ?>
                <div class="mt-6">
                    <?php echo e($expenses->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>

    
    <style>
        /* Equal height inputs like other pages */
        input[type="text"],
        input[type="number"],
        input[type="date"],
        select {
            box-sizing: border-box;
            height: 44px;
            padding-top: 0.35rem;
            padding-bottom: 0.35rem;
            padding-left: 0.6rem;
            padding-right: 0.6rem;
            line-height: 1.2;
        }

        /* Small screens: make edit-mode card visually distinct */
        .expense-row .edit-mode[hidden] {
            display: none;
        }

        .expense-row.editing {
            box-shadow: 0 6px 18px rgba(2, 6, 23, 0.06);
            border-left: 4px solid rgba(59, 130, 246, 1);
            background-color: rgba(59, 130, 246, 0.04);
        }

        .mobile-card.view-mode {
            padding: 0.25rem 0;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Helper: show in-card banner (replaces floating toast)
            const pageBanner = document.getElementById('pageBanner');
            let bannerTimeout = null;
            function showBanner(message, type = 'success', persist = false) {
                pageBanner.innerHTML = '';
                pageBanner.classList.remove('hidden');
                const div = document.createElement('div');
                div.className = type === 'error'
                    ? 'card-banner-error max-w-3xl rounded-2xl p-3 border border-rose-200 bg-rose-50 text-rose-800'
                    : 'card-banner-success max-w-3xl rounded-2xl p-3 border border-emerald-200 bg-emerald-50 text-emerald-800';
                div.setAttribute('role', 'status');
                div.innerHTML = `
                <div class="flex items-center justify-between gap-3">
                    <div class="text-sm font-semibold">${message}</div>
                    <div><button id="dismissBanner" class="text-xs underline">Dismiss</button></div>
                </div>
            `;
                pageBanner.appendChild(div);
                document.getElementById('dismissBanner')?.addEventListener('click', () => {
                    pageBanner.classList.add('hidden');
                    pageBanner.innerHTML = '';
                });
                if (!persist) {
                    if (bannerTimeout) clearTimeout(bannerTimeout);
                    bannerTimeout = setTimeout(() => { pageBanner.classList.add('hidden'); pageBanner.innerHTML = ''; }, 4500);
                }
            }

            // Fallback showToast (some of your other code uses showToast)
            function showToast(message, type = 'success') { showBanner(message, type, true); }

            // edit button behaviour (desktop + mobile)
            function enterEditMode(row) {
                // collapse other editing rows
                document.querySelectorAll('.expense-row').forEach(r => {
                    if (r !== row) {
                        r.classList.remove('editing');
                        r.querySelectorAll('.edit-mode').forEach(el => el.classList.add('hidden'));
                        r.querySelectorAll('.view-mode').forEach(el => el.classList.remove('hidden'));
                    }
                });

                row.classList.add('editing');
                row.querySelectorAll('.view-mode').forEach(el => el.classList.add('hidden'));
                row.querySelectorAll('.edit-mode').forEach(el => el.classList.remove('hidden'));
            }

            function exitEditMode(row) {
                row.classList.remove('editing');
                row.querySelectorAll('.edit-mode').forEach(el => el.classList.add('hidden'));
                row.querySelectorAll('.view-mode').forEach(el => el.classList.remove('hidden'));
            }

            // Attach events to edit/cancel buttons (delegation)
            document.addEventListener('click', function (e) {
                // Edit
                const editBtn = e.target.closest('.edit-btn');
                if (editBtn) {
                    const row = editBtn.closest('.expense-row');
                    if (row) enterEditMode(row);
                    return;
                }

                // Cancel
                const cancelBtn = e.target.closest('.cancel-btn');
                if (cancelBtn) {
                    const row = cancelBtn.closest('.expense-row');
                    if (row) exitEditMode(row);
                    return;
                }
            });

            // Handle attach-btn click (delegated)
            document.addEventListener('click', function (e) {
                const attachBtn = e.target.closest('.attach-btn');
                if (!attachBtn) return;
                const row = attachBtn.closest('.expense-row');
                if (!row) return;
                const fileInput = row.querySelector('.file-input');
                if (fileInput) fileInput.click();
            });

            // Save (AJAX) handler (delegated)
            document.addEventListener('click', function (e) {
                const saveBtn = e.target.closest('.save-btn');
                if (!saveBtn) return;
                const row = saveBtn.closest('.expense-row');
                if (!row) return;

                (async () => {
                    const updateUrl = row.dataset.updateUrl;
                    if (!updateUrl) { showToast('Save URL missing', 'error'); return; }

                    // gather fields from this row
                    const dateInput = row.querySelector('input[name="expense_date"]');
                    const groupInput = row.querySelector('input[name="group"]');
                    const partyInput = row.querySelector('input[name="party_name"]');
                    const purposeInput = row.querySelector('input[name="purpose"]');
                    const amountInput = row.querySelector('input[name="amount"]');
                    const fileInput = row.querySelector('.file-input');

                    const fd = new FormData();
                    fd.append('_method', 'PUT');
                    const tokenMeta = document.querySelector('meta[name="csrf-token"]');
                    if (tokenMeta) fd.append('_token', tokenMeta.getAttribute('content'));

                    if (dateInput) fd.append('expense_date', dateInput.value);
                    if (groupInput) fd.append('group', groupInput.value);
                    if (partyInput) fd.append('party_name', partyInput.value);
                    if (purposeInput) fd.append('purpose', purposeInput.value);
                    if (amountInput) fd.append('amount', amountInput.value);

                    // append any remove_files[] that may be present inside this row (if you implement per-row removal)
                    row.querySelectorAll('input[name="remove_files[]"]').forEach(i => fd.append('remove_files[]', i.value));

                    // append files
                    if (fileInput && fileInput.files.length) {
                        for (const f of Array.from(fileInput.files)) {
                            fd.append('add_files[]', f, f.name);
                        }
                    }

                    // UI: disable save btn and show spinner
                    const prevHtml = saveBtn.innerHTML;
                    saveBtn.disabled = true;
                    saveBtn.innerHTML = '<svg class="w-4 h-4 animate-spin inline-block" viewBox="0 0 24 24" fill="none" stroke="currentColor"><circle cx="12" cy="12" r="10" stroke-opacity="0.2" stroke-width="2"/><path d="M4 12a8 8 0 018-8" stroke-width="2" stroke-linecap="round"></path></svg>';

                    try {
                        const res = await fetch(updateUrl, { method: 'POST', headers: { 'Accept': 'application/json' }, body: fd });
                        if (res.status === 422) {
                            const data = await res.json().catch(() => ({}));
                            const msg = data.errors ? Object.values(data.errors).flat().join('\n') : 'Validation error';
                            showToast(msg, 'error');
                            return;
                        }
                        if (!res.ok) {
                            const data = await res.json().catch(() => ({}));
                            showToast(data.message || 'Server error while saving.', 'error');
                            return;
                        }

                        // update view-mode content from input values (best-effort)
                        try {
                            if (dateInput) {
                                const dateCol = row.querySelector('.col-span-2') || row.querySelector('[data-label="Date"]');
                                const viewDateMain = row.querySelector('.view-mode .text-sm');
                                if (viewDateMain) {
                                    const d = new Date(dateInput.value);
                                    // Show same format as before
                                    viewDateMain.textContent = d.toLocaleDateString(undefined, { month: 'short', day: 'numeric', year: 'numeric' });
                                }
                            }
                            if (groupInput) {
                                const vm = row.querySelector('.view-mode span');
                                if (vm) vm.textContent = groupInput.value || 'General';
                            }
                            if (partyInput) {
                                // find the appropriate view-mode cell and update its text
                                const partyView = row.querySelectorAll('.view-mode')[2];
                                if (partyView) partyView.textContent = partyInput.value || '-';
                            }
                            if (purposeInput) {
                                const purposeView = row.querySelectorAll('.view-mode')[3];
                                if (purposeView) purposeView.textContent = purposeInput.value || '-';
                            }
                            if (amountInput) {
                                // update any element that shows a price inside view-mode
                                row.querySelectorAll('.view-mode').forEach(vm => {
                                    if (vm.textContent && vm.textContent.trim().startsWith('₹')) {
                                        vm.textContent = '₹' + (Number(amountInput.value) || 0).toFixed(2);
                                    }
                                });
                            }
                        } catch (err) { console.error(err); }

                        showToast('Saved.', 'success');
                        exitEditMode(row);
                    } catch (err) {
                        console.error(err);
                        showToast('Network error', 'error');
                    } finally {
                        saveBtn.disabled = false;
                        saveBtn.innerHTML = prevHtml;
                    }
                })();
            });

            // File attach validation (delegated)
            document.addEventListener('change', function (e) {
                const fileInput = e.target.closest('.file-input');
                if (!fileInput) return;
                const files = Array.from(fileInput.files || []);
                const ALLOWED = ['image/png', 'image/jpeg', 'application/pdf'];
                const MAX_BYTES = 5 * 1024 * 1024;

                if (files.length === 0) return;

                for (const f of files) {
                    const ext = (f.name || '').split('.').pop()?.toLowerCase() || '';
                    const mimeOk = ALLOWED.includes(f.type);
                    const extOk = ['png', 'jpg', 'jpeg', 'pdf'].includes(ext);
                    if ((!mimeOk && !extOk) || f.size > MAX_BYTES) {
                        showToast('Invalid file selected. Allowed: PNG, JPG, PDF. Max 5MB each.', 'error');
                        fileInput.value = '';
                        return;
                    }
                }

                // Show feedback near the row (best-effort)
                const row = fileInput.closest('.expense-row');
                const summary = row?.querySelector('.file-summary') || row?.querySelector('.attached-summary');
                if (summary) {
                    summary.textContent = files.map(f => f.name).join(', ');
                }
                showToast(files.length + ' file(s) ready to upload', 'success');
            });

            // show server flash messages into banner if present
            <?php if(session('success')): ?>
                showBanner(<?php echo json_encode(session('success'), 15, 512) ?>, 'success', true);
            <?php endif; ?>
            <?php if(session('error')): ?>
                showBanner(<?php echo json_encode(session('error'), 15, 512) ?>, 'error', true);
            <?php endif; ?>
            <?php if($errors->any()): ?>
                showBanner(<?php echo json_encode($errors->first(), 15, 512) ?>, 'error', true);
            <?php endif; ?>
    });
    </script>

    
    <style>
        .card-banner-success {
            background-color: #ecfdf5;
            border: 1px solid #bbf7d0;
            color: #065f46;
            padding: 0.6rem 0.9rem;
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .card-banner-error {
            background-color: #fff1f2;
            border: 1px solid #fecaca;
            color: #9f1239;
            padding: 0.6rem 0.9rem;
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\softwares\26dec25Backup\resources\views/employee/expenses/index.blade.php ENDPATH**/ ?>