

<?php $__env->startSection('page-title', 'Employee – Month-wise Consolidated Conveyance'); ?>
<?php $__env->startSection('page-subtitle', 'Session: ' . ($activeSession->name ?? ($activeSession->label ?? 'Active'))); ?>

<?php $__env->startSection('content'); ?>

    <?php
        $totalEmployees = count($rows);
    ?>

    <div class="-mx-4 -mt-4 px-4 pb-8 md:px-6 lg:px-8">

        
        <?php if(empty($isExport)): ?>
            <div class="flex flex-col gap-3 md:flex-row md:items-center md:justify-between mb-4">
                <div class="space-y-1">
                    <div class="flex items-center gap-2 text-xs text-slate-500">
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="inline-flex items-center gap-1 hover:underline">
                            <span class="text-base leading-none">&larr;</span>
                            <span>Back to Dashboard</span>
                        </a>
                        <span class="hidden md:inline">|</span>
                        <span>Session:
                            <span class="font-semibold text-slate-700">
                                <?php echo e($activeSession->name ?? ($activeSession->label ?? '')); ?>

                            </span>
                        </span>
                    </div>
                    <h2 class="text-lg md:text-xl font-semibold text-slate-800">
                        Employee × Month-wise Consolidated Conveyance
                    </h2>
                    <p class="text-xs md:text-sm text-slate-500">
                        Each cell shows total submitted conveyance (onward + return, where applicable)
                        for that employee in the given month of the active session.
                    </p>
                </div>

                <div class="flex flex-wrap gap-2 justify-start md:justify-end">
                    <button onclick="window.print()"
                        class="inline-flex items-center rounded-md border border-slate-300 px-3 py-1.5 text-xs font-medium text-slate-700 bg-white hover:bg-slate-50">
                        🖨 Print
                    </button>

                    <a href="<?php echo e(route('admin.reports.employee-monthly-conveyance.export')); ?>"
                        class="inline-flex items-center rounded-md border border-emerald-600 px-3 py-1.5 text-xs font-semibold text-emerald-700 bg-emerald-50 hover:bg-emerald-100">
                        ⬇ Export to Excel
                    </a>
                </div>
            </div>

            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3 mb-4">
                <div class="rounded-lg border border-slate-200 bg-white px-4 py-3">
                    <p class="text-[11px] uppercase tracking-wide text-slate-500">Employees</p>
                    <p class="mt-1 text-lg font-semibold text-slate-800">
                        <?php echo e($totalEmployees); ?>

                    </p>
                </div>
                <div class="rounded-lg border border-slate-200 bg-white px-4 py-3">
                    <p class="text-[11px] uppercase tracking-wide text-slate-500">Overall Total</p>
                    <p class="mt-1 text-lg font-semibold text-slate-800">
                        ₹ <?php echo e(number_format($overallTotal, 2)); ?>

                    </p>
                </div>
                <div class="rounded-lg border border-slate-200 bg-white px-4 py-3">
                    <p class="text-[11px] uppercase tracking-wide text-slate-500">Months Covered</p>
                    <p class="mt-1 text-sm font-semibold text-slate-800">
                        <?php if(count($months)): ?>
                            <?php echo e($months[0]['label']); ?> – <?php echo e($months[count($months) - 1]['label']); ?>

                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </p>
                </div>
            </div>
        <?php endif; ?>

        
        <div class="rounded-lg border border-slate-200 bg-white shadow-sm overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full text-xs md:text-sm border-collapse">
                    <thead>
                        <tr class="bg-slate-50">
                            <th
                                class="sticky left-0 z-20 border-b border-r border-slate-200 bg-slate-50 px-3 py-2 text-left text-[11px] font-semibold uppercase tracking-wide text-slate-500">
                                Employee
                            </th>

                            <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th
                                    class="border-b border-slate-200 px-3 py-2 text-right text-[11px] font-semibold uppercase tracking-wide text-slate-500 whitespace-nowrap">
                                    <?php echo e($m['label']); ?>

                                </th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <th
                                class="border-b border-l border-slate-200 px-3 py-2 text-right text-[11px] font-semibold uppercase tracking-wide text-slate-500 whitespace-nowrap">
                                Grand&nbsp;Total
                            </th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $user = $row['user'];
                            ?>
                            <tr class="odd:bg-white even:bg-slate-50/40 hover:bg-emerald-50/40">
                                
                                <td
                                    class="sticky left-0 z-10 border-t border-r border-slate-200 bg-inherit px-3 py-2 text-xs md:text-sm font-medium text-slate-800 whitespace-nowrap">
                                    <?php echo e($user->name ?? ('User #' . $user->id)); ?>

                                </td>

                                
                                <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $key = $m['key'];
                                        $val = $row['monthly'][$key] ?? 0;
                                    ?>
                                    <td
                                        class="border-t border-slate-200 px-3 py-2 text-right align-middle text-[11px] md:text-xs text-slate-700">
                                        <?php if($val > 0): ?>
                                            ₹ <?php echo e(number_format($val, 2)); ?>

                                        <?php else: ?>
                                            <span class="text-slate-300">—</span>
                                        <?php endif; ?>
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                
                                <td
                                    class="border-t border-l border-slate-200 px-3 py-2 text-right align-middle text-xs md:text-sm font-semibold text-slate-900">
                                    <?php if($row['grand_total'] > 0): ?>
                                        ₹ <?php echo e(number_format($row['grand_total'], 2)); ?>

                                    <?php else: ?>
                                        <span class="text-slate-300">—</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="<?php echo e(1 + count($months) + 1); ?>" class="px-3 py-4 text-center text-xs text-slate-500">
                                    No submitted conveyance found for this session.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>

                    
                    <?php if(!empty($rows)): ?>
                        <tfoot class="bg-slate-50">
                            <tr>
                                <th
                                    class="sticky left-0 z-10 border-t border-r border-slate-200 bg-slate-50 px-3 py-2 text-xs font-semibold text-slate-800 text-left">
                                    TOTAL
                                </th>
                                <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $key = $m['key'];
                                                            $sumForMonth = 0;
                                                            foreach ($rows as $row) {
                                                                $sumForMonth += $row['monthly'][$key] ?? 0;
                                                            }
                                                        ?>
                                     <th
                                                            class="border-t border-slate-200 px-3 py-2 text-right text-[11px] font-semibold text-slate-800">
                                                            <?php if($sumForMonth > 0): ?>
                                                                ₹ <?php echo e(number_format($sumForMonth, 2)); ?>

                                                            <?php else: ?>
                                                                <span class="text-slate-300">—</span>
                                                            <?php endif; ?>
                                                        </th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <th
                                    class="border-t border-l border-slate-200 px-3 py-2 text-right text-xs font-semibold text-slate-900">
                                    ₹ <?php echo e(number_format($overallTotal, 2)); ?>

                                </th>
                            </tr>
                        </tfoot>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin_fullwidth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\softwares\26dec25Backup\resources\views/admin/reports/employee_monthly_consolidated.blade.php ENDPATH**/ ?>