

<?php $__env->startSection('page-title', 'Leave Management'); ?>
<?php $__env->startSection('page-subtitle', 'Manage employee leave applications'); ?>

<?php $__env->startSection('content'); ?>
    <div class="min-h-screen bg-slate-50 py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            <!-- Filters (Optional, keeping it simple for now) -->
            <div class="mb-6 flex justify-end">
                <a href="<?php echo e(route('admin.leaves.index', ['status' => 'pending'])); ?>"
                    class="px-4 py-2 bg-white text-slate-600 rounded-lg shadow-sm mr-2 text-sm font-medium hover:bg-slate-50">Pending</a>
                <a href="<?php echo e(route('admin.leaves.index', ['status' => 'approved'])); ?>"
                    class="px-4 py-2 bg-white text-slate-600 rounded-lg shadow-sm mr-2 text-sm font-medium hover:bg-slate-50">Approved</a>
                <a href="<?php echo e(route('admin.leaves.index', ['status' => 'rejected'])); ?>"
                    class="px-4 py-2 bg-white text-slate-600 rounded-lg shadow-sm mr-2 text-sm font-medium hover:bg-slate-50">Rejected</a>
                <a href="<?php echo e(route('admin.leaves.index')); ?>"
                    class="px-4 py-2 bg-white text-slate-600 rounded-lg shadow-sm text-sm font-medium hover:bg-slate-50">All</a>
            </div>

            <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-slate-100 flex items-center justify-between bg-slate-50/50">
                    <h2 class="text-base font-bold text-slate-800">Leave Applications</h2>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full text-sm text-left">
                        <thead class="bg-slate-50 text-slate-500 uppercase font-bold text-xs">
                            <tr>
                                <th class="px-6 py-3">Employee</th>
                                <th class="px-6 py-3">Dates</th>
                                <th class="px-6 py-3">Duration</th>
                                <th class="px-6 py-3">Reason</th>
                                <th class="px-6 py-3">Status</th>
                                <th class="px-6 py-3">Action</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-100">
                            <?php $__empty_1 = true; $__currentLoopData = $leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="hover:bg-slate-50/50 transition">
                                    <td class="px-6 py-4 font-medium text-slate-800">
                                        <?php echo e($leave->employee->user->name ?? 'Unknown'); ?>

                                        <div class="text-xs text-slate-400 font-normal">
                                            <?php echo e($leave->employee->designation ?? ''); ?></div>
                                    </td>
                                    <td class="px-6 py-4 text-slate-600">
                                        <div class="flex flex-col">
                                            <span>From: <?php echo e(\Carbon\Carbon::parse($leave->start_date)->format('d M Y')); ?></span>
                                            <span>To: <?php echo e(\Carbon\Carbon::parse($leave->end_date)->format('d M Y')); ?></span>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 text-slate-600">
                                        <?php echo e($leave->total_days); ?> Days
                                    </td>
                                    <td class="px-6 py-4 text-slate-600 text-xs max-w-xs truncate" title="<?php echo e($leave->reason); ?>">
                                        <?php echo e(Str::limit($leave->reason, 50)); ?>

                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="px-2.5 py-1 rounded-full text-xs font-bold
                                            <?php if($leave->status === 'approved'): ?> bg-emerald-100 text-emerald-700
                                            <?php elseif($leave->status === 'rejected'): ?> bg-red-100 text-red-700
                                            <?php else: ?> bg-amber-100 text-amber-700
                                            <?php endif; ?>">
                                            <?php echo e(ucfirst($leave->status)); ?>

                                        </span>
                                    </td>
                                    <td class="px-6 py-4">
                                        <?php if($leave->status === 'pending'): ?>
                                            <div class="flex gap-2">
                                                <button onclick="openModal('<?php echo e($leave->id); ?>', 'approved')"
                                                    class="px-3 py-1.5 bg-emerald-600 text-white rounded-lg text-xs font-bold shadow-sm hover:bg-emerald-700 transition">
                                                    Approve
                                                </button>
                                                <button onclick="openModal('<?php echo e($leave->id); ?>', 'rejected')"
                                                    class="px-3 py-1.5 bg-red-600 text-white rounded-lg text-xs font-bold shadow-sm hover:bg-red-700 transition">
                                                    Reject
                                                </button>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-xs text-slate-400 italic">
                                                <?php echo e($leave->admin_remark ? 'Remark: ' . $leave->admin_remark : 'No Remark'); ?>

                                            </span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="px-6 py-8 text-center text-slate-400 italic">
                                        No leave applications found.
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="px-6 py-4 border-t border-slate-100">
                    <?php echo e($leaves->withQueryString()->links()); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div id="actionModal"
        class="fixed inset-0 z-50 hidden bg-slate-900/50 backdrop-blur-sm flex items-center justify-center p-4">
        <div class="bg-white rounded-2xl shadow-xl w-full max-w-md overflow-hidden transform transition-all">
            <div class="px-6 py-4 border-b border-slate-100 bg-slate-50 flex justify-between items-center">
                <h3 class="text-lg font-bold text-slate-800" id="modalTitle">Update Status</h3>
                <button onclick="closeModal()" class="text-slate-400 hover:text-slate-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                        </path>
                    </svg>
                </button>
            </div>

            <form id="actionForm" method="POST" action="">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="status" id="modalStatusInput">

                <div class="p-6 space-y-4">
                    <p class="text-sm text-slate-600">
                        Are you sure you want to <span id="modalActionText" class="font-bold"></span> this leave
                        application?
                    </p>

                    <div>
                        <label class="block text-xs font-bold text-slate-700 uppercase mb-1">Admin Remark (Optional)</label>
                        <textarea name="admin_remark" rows="3"
                            class="w-full text-sm border-slate-200 rounded-lg focus:ring-indigo-500 focus:border-indigo-500 placeholder-slate-400"
                            placeholder="Add a note..."></textarea>
                    </div>
                </div>

                <div class="px-6 py-4 bg-slate-50 border-t border-slate-100 flex justify-end gap-3">
                    <button type="button" onclick="closeModal()"
                        class="px-4 py-2 bg-white border border-slate-300 rounded-lg text-slate-600 text-sm font-medium hover:bg-slate-50">Cancel</button>
                    <button type="submit" id="modalSubmitBtn"
                        class="px-4 py-2 rounded-lg text-white text-sm font-bold shadow-sm transition">
                        Confirm
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function openModal(leaveId, status) {
            const modal = document.getElementById('actionModal');
            const form = document.getElementById('actionForm');
            const title = document.getElementById('modalTitle');
            const actionText = document.getElementById('modalActionText');
            const statusInput = document.getElementById('modalStatusInput');
            const submitBtn = document.getElementById('modalSubmitBtn');

            // Reset form action
            form.action = `/admin/leaves/${leaveId}/status`;

            // Set content
            statusInput.value = status;
            actionText.textContent = status;

            if (status === 'approved') {
                title.textContent = 'Approve Leave';
                submitBtn.className = 'px-4 py-2 rounded-lg text-white text-sm font-bold shadow-sm transition bg-emerald-600 hover:bg-emerald-700';
                submitBtn.textContent = 'Approve';
            } else {
                title.textContent = 'Reject Leave';
                submitBtn.className = 'px-4 py-2 rounded-lg text-white text-sm font-bold shadow-sm transition bg-red-600 hover:bg-red-700';
                submitBtn.textContent = 'Reject';
            }

            modal.classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('actionModal').classList.add('hidden');
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\softwares\26dec25Backup\resources\views/admin/leaves/index.blade.php ENDPATH**/ ?>