<?php $__env->startSection('page-title', 'Client – ' . ($client->name ?? 'Unknown')); ?>
<?php $__env->startSection('page-subtitle', 'Employee-wise and entry-wise submitted conveyance for ' . ($currentMonthLabel ?? '')); ?>

<?php use Illuminate\Support\Str; ?>

<?php $__env->startSection('content'); ?>

<div class="mb-6">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-4">
        <div>
            <h2 class="text-2xl font-extrabold tracking-tight mb-1">
                <?php echo e($client->name ?? 'Unknown Client'); ?>

            </h2>
            <p class="text-sm text-[color:var(--muted)]">
                Period:
                <span class="font-semibold text-emerald-700"><?php echo e($currentMonthLabel); ?></span>
                &nbsp;•&nbsp; Submitted entries only 
            </p>
        </div>

        <div class="flex flex-wrap gap-2 justify-end">
            
            <a href="<?php echo e(route('admin.conveyance.clientEmployees.exportSummary', array_merge(['client' => $client->id], request()->query()))); ?>" 
               class="inline-flex items-center gap-2 px-3 py-2 rounded-xl bg-emerald-600 text-white text-xs md:text-sm font-semibold hover:bg-emerald-700 shadow-sm transition">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/></svg>
                Export Summary
            </a>

            
            <a href="<?php echo e(route('admin.conveyance.clientEmployees.exportDetailed', array_merge(['client' => $client->id], request()->query()))); ?>" 
               class="inline-flex items-center gap-2 px-3 py-2 rounded-xl bg-indigo-600 text-white text-xs md:text-sm font-semibold hover:bg-indigo-700 shadow-sm transition">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
                Export Day-wise (Sheet/Emp)
            </a>

            
            <a href="<?php echo e(route('admin.conveyance.clients', request()->query())); ?>"
               class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-white border border-[color:var(--border)] text-xs md:text-sm font-semibold hover:bg-slate-50 shadow-sm text-[color:var(--text)]">
               <span>←</span> Back to Summary
            </a>
        </div>
    </div>

    <div class="mt-3 flex flex-wrap gap-3 text-[11px] text-[color:var(--muted)]">
        <?php if($client->city): ?>
            <span class="px-2.5 py-1 rounded-full bg-slate-50 border border-[color:var(--border)]">
                City: <span class="font-semibold"><?php echo e($client->city); ?></span>
            </span>
        <?php endif; ?>

        
        <span class="px-2.5 py-1 rounded-full bg-emerald-50 border border-emerald-200 text-emerald-700">
            Total Amount: <span class="font-semibold">₹ <?php echo e(number_format($totalAmount, 2)); ?></span>
        </span>

        <span class="px-2.5 py-1 rounded-full bg-slate-50 border border-[color:var(--border)]">
            Entries: <span class="font-semibold"><?php echo e($totalEntries); ?></span>
        </span>

        <span class="px-2.5 py-1 rounded-full bg-slate-50 border border-[color:var(--border)]">
            Employees: <span class="font-semibold"><?php echo e($employeeCount); ?></span>
        </span>
    </div>
</div>

<?php if($rows->isEmpty()): ?>
    <div class="rounded-3xl bg-[color:var(--surface)] border border-[color:var(--border)] shadow-sm p-6 text-sm text-[color:var(--muted)]">
        No submitted conveyance entries found for this client in <?php echo e($currentMonthLabel); ?>.
    </div>
<?php else: ?>

    
    <div class="rounded-3xl bg-[color:var(--surface)] border border-[color:var(--border)] shadow-sm p-5 mb-6">

        
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3 mb-3">
            <div>
                <h3 class="font-extrabold text-lg">Employee-wise Summary</h3>
                <p class="text-[12px] text-[color:var(--muted)]">
                    Click on a row to expand and verify detailed entries for this client in <?php echo e($currentMonthLabel); ?>.
                </p>
            </div>

            <div class="flex flex-wrap gap-2 md:justify-end">
                <div class="relative">
                    <input
                        id="emp-summary-search"
                        type="text"
                        placeholder="Search employee or email..."
                        class="pl-8 pr-3 py-2 rounded-xl border border-[color:var(--border)] text-[13px] bg-[color:var(--bg-2)]
                               focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)] min-w-[220px]"
                    >
                    <span class="absolute left-2 top-1/2 -translate-y-1/2 text-[color:var(--muted)] text-xs">
                        🔍
                    </span>
                </div>

                <select
                    id="emp-summary-sort"
                    class="px-3 py-2 rounded-xl border border-[color:var(--border)] text-[13px] bg-[color:var(--bg-2)]
                           focus:outline-none focus:ring-2 focus:ring-[color:var(--brand)] focus:border-[color:var(--brand)]"
                >
                    <option value="amount_desc">Sort: Amount (High → Low)</option>
                    <option value="amount_asc">Sort: Amount (Low → High)</option>
                    <option value="name_asc">Sort: Name (A → Z)</option>
                    <option value="name_desc">Sort: Name (Z → A)</option>
                </select>
            </div>
        </div>

        
        <div class="rounded-2xl border border-[color:var(--border)] bg-white max-h-[420px] overflow-y-auto">
            <table class="w-full text-sm" id="emp-summary-table">
                <thead class="sticky top-0 z-10 bg-slate-50 text-[11px] uppercase tracking-wide text-[color:var(--muted)]">
                    <tr>
                        <th class="p-3 text-left font-semibold w-[18rem]">Employee</th>
                        <th class="p-3 text-left font-semibold">Email</th>
                        <th class="p-3 text-right font-semibold w-[8rem]">Amount (₹)</th>
                        <th class="p-3 text-center font-semibold w-[6rem]">Entries</th>
                        <th class="p-3 text-right font-semibold w-[7rem]">Details</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-[color:var(--border)]" id="emp-summary-tbody">
                    <?php $__currentLoopData = $employeeGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userId => $empItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $user      = $empItems->first()->user;
                            $empName   = $user->name ?? 'Unknown';
                            $empEmail  = $user->email ?? '';

                            // effective per-employee total (onward + return/custom)
                            $empAmount = $empItems->sum(function($c) {
                                $onward = (float) $c->amount;
                                if ($c->is_return) {
                                    $return = $c->return_amount !== null
                                        ? (float) $c->return_amount
                                        : $onward;
                                    return $onward + $return;
                                }
                                return $onward;
                            });

                            $empCount  = $empItems->count();
                        ?>

                        
                        <tr
                            class="hover:bg-slate-50 transition summary-row"
                            data-row-type="summary"
                            data-user-id="<?php echo e($userId); ?>"
                            data-name="<?php echo e(Str::lower($empName)); ?>"
                            data-email="<?php echo e(Str::lower($empEmail)); ?>"
                            data-amount="<?php echo e($empAmount); ?>"
                        >
                            <td class="p-3 align-top">
                                <div class="flex items-center gap-2">
                                    <div class="h-7 w-7 rounded-full bg-[color:var(--bg-2)] text-[color:var(--brand-dark)]
                                                grid place-items-center text-[11px] font-semibold">
                                        <?php echo e(Str::upper(Str::substr($empName, 0, 2))); ?>

                                    </div>
                                    <div class="min-w-0">
                                        <div class="font-semibold text-[color:var(--text)] truncate">
                                            <?php echo e($empName); ?>

                                        </div>
                                        <div class="text-[11px] text-[color:var(--muted)] truncate">
                                            User ID: <?php echo e($userId); ?>

                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="p-3 align-top text-[color:var(--muted)] truncate">
                                <?php echo e($empEmail); ?>

                            </td>
                            <td class="p-3 text-right align-top font-extrabold text-emerald-700 whitespace-nowrap">
                                ₹ <?php echo e(number_format($empAmount, 2)); ?>

                            </td>
                            <td class="p-3 text-center align-top">
                                <span class="inline-flex items-center justify-center px-2 py-0.5 rounded-full
                                             bg-slate-50 border border-[color:var(--border)] text-[11px]">
                                    <?php echo e($empCount); ?>

                                </span>
                            </td>
                            <td class="p-3 text-right align-top">
                                <button type="button"
                                        class="toggle-details inline-flex items-center gap-1 px-3 py-1.5 rounded-xl
                                               bg-[color:var(--bg-2)] border border-[color:var(--border)]
                                               text-[11px] font-semibold text-[color:var(--text)]
                                               hover:bg-slate-100 transition"
                                        data-user-id="<?php echo e($userId); ?>">
                                    <span class="chevron-icon inline-block transform transition-transform">▼</span>
                                    <span>View</span>
                                </button>
                            </td>
                        </tr>

                        
                        <tr
                            class="detail-row hidden bg-slate-50/60"
                            data-row-type="detail"
                            data-user-id="<?php echo e($userId); ?>"
                        >
                            <td colspan="5" class="p-0">
                                <div class="px-4 pb-4 pt-1">
                                    <div class="flex items-center justify-between mt-1">
                                        <div class="text-[11px] uppercase tracking-[0.16em] text-[color:var(--muted)]">
                                            Submitted Entries (Verification View)
                                        </div>
                                        <div class="text-[11px] text-[color:var(--muted)]">
                                            <?php echo e($empCount); ?> entries • ₹ <?php echo e(number_format($empAmount, 2)); ?>

                                        </div>
                                    </div>

                                    <div class="mt-2 max-h-[260px] overflow-y-auto border border-[color:var(--border)]
                                                rounded-2xl bg-white">
                                        <table class="w-full text-[12px]">
                                            <thead class="bg-slate-50 text-[10px] uppercase tracking-wide text-[color:var(--muted)]">
                                                <tr>
                                                    <th class="p-2 text-left font-semibold w-[7rem]">Date</th>
                                                    <th class="p-2 text-left font-semibold w-[8rem]">From</th>
                                                    <th class="p-2 text-left font-semibold w-[8rem]">To</th>
                                                    <th class="p-2 text-left font-semibold w-[9rem]">Mode</th>
                                                    <th class="p-2 text-right font-semibold w-[6rem]">Onward (₹)</th>
                                                    <th class="p-2 text-right font-semibold w-[6rem]">Return (₹)</th>
                                                    <th class="p-2 text-right font-semibold w-[6rem]">Total (₹)</th>
                                                    <th class="p-2 text-left font-semibold">Remarks</th>
                                                    <th class="p-2 text-center font-semibold w-[5rem]">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody class="divide-y divide-[color:var(--border)]">
                                                <?php $__currentLoopData = $empItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $onward = (float) $c->amount;

                                                        if ($c->is_return) {
                                                            $return = $c->return_amount !== null
                                                                ? (float) $c->return_amount
                                                                : $onward;
                                                        } else {
                                                            $return = 0.0;
                                                        }

                                                        $rowTotal = $onward + $return;
                                                        $hasReturn = $c->is_return;
                                                        $isSame   = $hasReturn && ($c->return_amount === null || (float)$c->return_amount == $onward);
                                                    ?>
                                                    <tr class="hover:bg-slate-50/70">
                                                        <td class="p-2 align-top">
                                                            <?php echo e($c->date->format('d M Y')); ?>

                                                        </td>
                                                        <td class="p-2 align-top">
                                                            <?php echo e($c->from_location); ?>

                                                        </td>
                                                        <td class="p-2 align-top">
                                                            <?php echo e($c->to_location); ?>

                                                        </td>
                                                        <td class="p-2 align-top">
                                                            <?php echo e($c->mode ?? '-'); ?>

                                                            <?php if($hasReturn): ?>
                                                                <span class="ml-1 inline-flex px-1.5 py-0.5 rounded-full bg-emerald-50 text-emerald-700 border border-emerald-200 text-[10px]">
                                                                    Return
                                                                </span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="p-2 text-right align-top font-semibold text-slate-800">
                                                            ₹ <?php echo e(number_format($onward, 2)); ?>

                                                        </td>
                                                        <td class="p-2 text-right align-top text-slate-800">
                                                            <?php if($hasReturn): ?>
                                                                <div class="flex items-center justify-end gap-1">
                                                                    <span class="font-semibold">
                                                                        ₹ <?php echo e(number_format($return, 2)); ?>

                                                                    </span>
                                                                    <span class="inline-flex px-1.5 py-0.5 rounded-full text-[9px]
                                                                        <?php echo e($isSame
                                                                            ? 'bg-emerald-50 text-emerald-700 border border-emerald-200'
                                                                            : 'bg-amber-50 text-amber-700 border border-amber-200'); ?>">
                                                                        <?php echo e($isSame ? 'Same' : 'Different'); ?>

                                                                    </span>
                                                                </div>
                                                            <?php else: ?>
                                                                <span class="text-slate-400">—</span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="p-2 text-right align-top font-semibold text-slate-800">
                                                            ₹ <?php echo e(number_format($rowTotal, 2)); ?>

                                                        </td>
                                                        <td class="p-2 align-top text-slate-700">
                                                            
                                                            <?php echo e($c->remarks ?: '-'); ?>


                                                            
                                                            <?php if($hasReturn && !empty($c->return_remarks)): ?>
                                                                <div class="mt-0.5 text-[10px] text-[color:var(--muted)]">
                                                                    Return note: <?php echo e($c->return_remarks); ?>

                                                                </div>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="p-2 text-center align-top">
                                                            <?php if($c->status === 'submitted'): ?>
                                                                <span class="inline-flex px-2 py-0.5 rounded-full bg-emerald-50 text-emerald-700 border border-emerald-200 text-[10px]">
                                                                    Submitted
                                                                </span>
                                                            <?php else: ?>
                                                                <span class="inline-flex px-2 py-0.5 rounded-full bg-amber-50 text-amber-700 border border-amber-200 text-[10px]">
                                                                    Draft
                                                                </span>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php if($employeeGroups->isEmpty()): ?>
                        <tr>
                            <td colspan="5" class="p-4 text-center text-[13px] text-[color:var(--muted)]">
                                No employees have submitted conveyance for this client in <?php echo e($currentMonthLabel); ?>.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const searchInput = document.getElementById('emp-summary-search');
    const sortSelect  = document.getElementById('emp-summary-sort');
    const tbody       = document.getElementById('emp-summary-tbody');

    if (!searchInput || !sortSelect || !tbody) return;

    function getSummaryRows() {
        return Array.from(tbody.querySelectorAll('tr[data-row-type="summary"]'));
    }

    function getDetailRowFor(userId) {
        return tbody.querySelector('tr[data-row-type="detail"][data-user-id="' + userId + '"]');
    }

    function applyFilterAndSort() {
        const q = (searchInput.value || '').trim().toLowerCase();
        const sortMode = sortSelect.value;
        const summaryRows = getSummaryRows();

        // Filter
        summaryRows.forEach(row => {
            const name  = (row.dataset.name  || '').toLowerCase();
            const email = (row.dataset.email || '').toLowerCase();
            const match = !q || name.includes(q) || email.includes(q);
            const detail = getDetailRowFor(row.dataset.userId);

            row.style.display = match ? '' : 'none';
            if (detail) {
                // hide detail as well if summary hidden
                detail.style.display = match && !detail.classList.contains('hidden') ? '' : 'none';
            }
        });

        // Sort visible rows
        const visibleRows = summaryRows.filter(r => r.style.display !== 'none');

        visibleRows.sort((a, b) => {
            const aName = a.dataset.name || '';
            const bName = b.dataset.name || '';
            const aAmt  = parseFloat(a.dataset.amount || 0);
            const bAmt  = parseFloat(b.dataset.amount || 0);

            switch (sortMode) {
                case 'amount_asc':
                    return aAmt - bAmt;
                case 'amount_desc':
                    return bAmt - aAmt;
                case 'name_desc':
                    return bName.localeCompare(aName);
                case 'name_asc':
                default:
                    return aName.localeCompare(bName);
            }
        });

        // Re-append summary + its detail together
        visibleRows.forEach(summary => {
            const detail = getDetailRowFor(summary.dataset.userId);
            tbody.appendChild(summary);
            if (detail) tbody.appendChild(detail);
        });
    }

    // Toggle details on button click
    tbody.addEventListener('click', function (e) {
        const btn = e.target.closest('.toggle-details');
        if (!btn) return;

        const userId = btn.dataset.userId;
        const detailRow = getDetailRowFor(userId);
        if (!detailRow) return;

        const isHidden = detailRow.classList.contains('hidden');

        // Close all other details
        Array.from(tbody.querySelectorAll('tr[data-row-type="detail"]')).forEach(row => {
            if (row !== detailRow) {
                row.classList.add('hidden');
                row.style.display = 'none';
            }
        });
        Array.from(tbody.querySelectorAll('.toggle-details .chevron-icon')).forEach(icon => {
            icon.style.transform = 'rotate(0deg)';
        });

        // Toggle this one
        if (isHidden) {
            detailRow.classList.remove('hidden');
            detailRow.style.display = '';
            const icon = btn.querySelector('.chevron-icon');
            if (icon) icon.style.transform = 'rotate(180deg)';
        } else {
            detailRow.classList.add('hidden');
            detailRow.style.display = 'none';
            const icon = btn.querySelector('.chevron-icon');
            if (icon) icon.style.transform = 'rotate(0deg)';
        }
    });

    // Events
    searchInput.addEventListener('input', applyFilterAndSort);
    sortSelect.addEventListener('change', applyFilterAndSort);

    // Initial sort
    applyFilterAndSort();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\softwares\26dec25Backup\resources\views/admin/conveyance/client_employees.blade.php ENDPATH**/ ?>