

<?php $__env->startSection('page-title', 'Claim History'); ?>
<?php $__env->startSection('page-subtitle', 'View your past conveyance claims'); ?>

<?php $__env->startSection('content'); ?>

    <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <h1 class="text-xl font-bold text-gray-900">Claim History</h1>
            <p class="text-sm text-gray-500">View your past conveyance claims</p>
        </div>

        <div class="flex items-center gap-3">
            <!-- Session Selector -->
            <form method="GET" action="<?php echo e(route('employee.conveyance.history')); ?>" class="flex items-center gap-2">
                <label for="session_id" class="text-sm font-medium text-gray-700 hidden sm:block">Session:</label>
                <select name="session_id" id="session_id" onchange="this.form.submit()"
                    class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-indigo-500 focus:border-indigo-500 block w-full p-2">
                    <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($session->id); ?>" <?php echo e(isset($currentSession) && $currentSession->id == $session->id ? 'selected' : ''); ?>>
                            <?php echo e($session->name ?? ($session->start_date->format('Y') . '-' . $session->end_date->format('Y'))); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>

            <a href="<?php echo e(route('employee.conveyance.index')); ?>"
                class="px-4 py-2 bg-white text-gray-700 text-sm font-medium rounded-lg border border-gray-300 hover:bg-gray-50 transition shadow-sm">
                Back to Current
            </a>
        </div>
    </div>

    <!-- History Cards Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">

        <?php $__empty_1 = true; $__currentLoopData = $historySummary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <a href="<?php echo e(route('employee.conveyance.showMonth', $h['month_key'])); ?>"
                class="group block bg-white border border-gray-200 rounded-xl shadow-sm hover:shadow-md transition-all duration-200 overflow-hidden relative">

                <?php if($h['is_current']): ?>
                    <div class="absolute top-0 right-0 p-3">
                        <span class="inline-flex items-center px-2 py-1 rounded bg-blue-50 text-blue-700 text-xs font-semibold">
                            Current Window
                        </span>
                    </div>
                <?php endif; ?>

                <div class="p-5">
                    <div class="flex items-center gap-4 mb-4">
                        <div
                            class="w-12 h-12 rounded-full bg-indigo-50 flex items-center justify-center text-indigo-600 group-hover:bg-indigo-600 group-hover:text-white transition-colors duration-200">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900 group-hover:text-indigo-600 transition-colors">
                                <?php echo e($h['month_label']); ?>

                            </h3>
                            <p class="text-sm text-gray-500">Submitted</p>
                        </div>
                    </div>

                    <div class="border-t border-gray-100 pt-4 flex items-center justify-between">
                        <div>
                            <p class="text-xs text-gray-500 uppercase tracking-wide">Total Amount</p>
                            <p class="text-lg font-bold text-emerald-600">₹<?php echo e(number_format($h['total'])); ?></p>
                        </div>
                        <div class="text-right">
                            <div
                                class="w-8 h-8 rounded-full bg-gray-50 flex items-center justify-center text-gray-400 group-hover:translate-x-1 transition-transform">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24"
                                    stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-span-full py-12 text-center bg-white rounded-xl border border-dashed border-gray-300">
                <div class="inline-flex w-16 h-16 rounded-full bg-gray-50 items-center justify-center mb-4">
                    <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
                <h3 class="text-lg font-medium text-gray-900">No History Found</h3>
                <p class="text-gray-500 mt-1">You haven't submitted any conveyance claims yet.</p>
            </div>
        <?php endif; ?>

    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\softwares\26dec25Backup\resources\views/employee/conveyance/history.blade.php ENDPATH**/ ?>