<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(config('app.name', 'PAC Technology')); ?> | Admin</title>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    
    <style>
        :root{
            /* APP SHELL */
            --bg: #F3F6FC;          /* page background */
            --bg-2: #E9EFFA;        /* subtle alt bg */
            --surface: #FFFFFF;     /* cards, nav, sidebar */
            --border: #E2E8F5;      /* soft border */

            /* SIDEBAR */
            --sidebar-bg: #FFFFFF;
            --sidebar-border: #E4E7F5;
            --sidebar-text: #1F2933;
            --sidebar-muted: #6B7280;
            --sidebar-pill: #EEF2FF;

            /* BRAND */
            --brand: #2563EB;       /* primary blue */
            --brand-soft: #E0EAFF;  /* soft pill blue */
            --brand-dark: #1D4ED8;
            --accent: #F97316;      /* accent orange */

            /* TEXT */
            --text: #111827;
            --muted: #6B7280;
        }

        html {
            scroll-behavior: smooth;
        }

        /* SIDEBAR COLLAPSE BEHAVIOUR */
        #sidebar {
            width: 18rem; /* same as w-72 */
        }

        body.sidebar-collapsed #sidebar {
            width: 4.5rem; /* compact width */
        }

        body.sidebar-collapsed #sidebar .sidebar-label,
        body.sidebar-collapsed #sidebar .sidebar-brand-text,
        body.sidebar-collapsed #sidebar .sidebar-profile,
        body.sidebar-collapsed #sidebar .sidebar-section-label {
            display: none;
        }
    </style>
</head>

<body class="min-h-screen text-[color:var(--text)] bg-[color:var(--bg)] overflow-x-hidden">


<header class="lg:hidden sticky top-0 z-50 bg-[color:var(--surface)] border-b border-[color:var(--border)]">
    <div class="px-4 py-3 flex items-center justify-between">

        <button id="openSidebar"
                class="p-2 rounded-xl hover:bg-slate-100 active:scale-95 transition">
            <svg class="w-6 h-6 text-slate-800" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M4 6h16M4 12h16M4 18h16"/>
            </svg>
        </button>

        <div class="flex items-center gap-2">
            <div class="h-9 w-9 rounded-2xl bg-[color:var(--brand)] grid place-items-center text-white font-extrabold shadow-md">
                P
            </div>
            <div class="leading-tight">
                <div class="font-extrabold text-sm">PAC Technology</div>
                <div class="text-[11px] text-[color:var(--muted)]">Admin Panel</div>
            </div>
        </div>

        <form method="POST" action="<?php echo e(route('logout')); ?>">
            <?php echo csrf_field(); ?>
            <button class="px-3 py-2 rounded-xl bg-rose-600 text-white text-xs font-semibold hover:bg-rose-700 transition">
                Logout
            </button>
        </form>
    </div>
</header>

<div class="flex min-h-screen">

    
    <div id="sidebarOverlay" class="fixed inset-0 bg-black/30 z-40 hidden lg:hidden"></div>

    
    <aside id="sidebar"
           class="fixed lg:static inset-y-0 left-0 z-50 w-72
                  bg-[color:var(--sidebar-bg)]
                  border-r border-[color:var(--sidebar-border)]
                  text-[color:var(--sidebar-text)]
                  transform -translate-x-full lg:translate-x-0
                  transition-transform duration-200 ease-out
                  flex flex-col">

        
        <div class="px-5 pt-5 pb-4 border-b border-[color:var(--sidebar-border)] bg-white">
            <div class="flex items-center gap-3">
                <div class="h-11 w-11 rounded-2xl bg-[color:var(--brand)] grid place-items-center text-white text-xl font-extrabold shadow-md">
                    P
                </div>
                <div class="sidebar-brand-text">
                    <div class="font-extrabold text-[17px] tracking-tight">PAC Technology</div>
                    <div class="text-[11px] text-[color:var(--muted)]">Conveyance System</div>
                </div>
            </div>

            
            <div class="mt-4 p-3 rounded-2xl bg-[color:var(--sidebar-pill)] border border-[color:var(--sidebar-border)] sidebar-profile">
                <div class="text-[10px] uppercase tracking-[0.14em] text-[color:var(--sidebar-muted)]">Logged in as</div>
                <div class="text-[13px] font-semibold text-[color:var(--sidebar-text)] truncate mt-1">
                    <?php echo e(auth()->user()->email); ?>

                </div>
            </div>
        </div>

        <?php echo $__env->make('admin.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <div class="mt-auto px-5 py-4 border-t border-[color:var(--sidebar-border)] text-[11px] text-[color:var(--sidebar-muted)] bg-[color:var(--surface)]">
            <div class="flex items-center justify-between">
                <span>© <?php echo e(date('Y')); ?> PAC Technology</span>
                <span class="px-2 py-0.5 rounded-full bg-[color:var(--brand-soft)] text-[color:var(--brand-dark)] text-[10px] font-semibold uppercase tracking-wide">
                    Admin
                </span>
            </div>
        </div>
    </aside>

    
    <main class="flex-1 w-full flex flex-col">

        
        <div class="hidden lg:flex sticky top-0 z-30 bg-[color:var(--surface)] border-b border-[color:var(--border)]">
            <div class="w-full px-6 py-4 flex items-center justify-between">
                <div class="flex items-center gap-3">
                    
                    <button id="toggleSidebar"
                            class="hidden lg:inline-flex p-2 rounded-xl border border-[color:var(--border)] bg-[color:var(--surface)] hover:bg-slate-50 text-[color:var(--muted)]">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M4 6h16M4 12h10M4 18h16"/>
                        </svg>
                    </button>

                    <div>
                        <div class="text-xl font-extrabold tracking-tight flex items-center gap-2">
                            <?php echo $__env->yieldContent('page-title', 'Admin Dashboard'); ?>
                            <span class="px-2 py-0.5 rounded-full text-[10px] bg-[color:var(--brand-soft)] text-[color:var(--brand-dark)] uppercase tracking-wide">
                                PAC Admin
                            </span>
                        </div>
                        <div class="text-xs text-[color:var(--muted)] mt-1"><?php echo $__env->yieldContent('page-subtitle', ''); ?></div>
                    </div>
                </div>

                <div class="flex items-center gap-3">
                    <div class="px-3 py-2 rounded-xl bg-[color:var(--bg-2)] border border-[color:var(--border)] text-[11px] flex items-center gap-2">
                        <span class="inline-flex h-2 w-2 rounded-full bg-emerald-500"></span>
                        <span class="uppercase tracking-wide text-[10px] text-[color:var(--muted)]">Active Session</span>
                        <span class="font-semibold text-xs text-[color:var(--text)]">
                            <?php echo e(\App\Models\Session::active()?->name ?? 'Not Set'); ?>

                        </span>
                    </div>

                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button class="px-4 py-2 rounded-xl bg-[color:var(--brand)] text-white text-sm font-semibold hover:bg-[color:var(--brand-dark)] transition shadow-sm">
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </div>

        
        <div class="px-4 lg:px-6 pt-4 space-y-3">
            <?php if(session('success')): ?>
                <div class="mb-2 p-3 rounded-2xl bg-emerald-50 text-emerald-800 border border-emerald-200 shadow-sm text-sm">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(isset($errors) && $errors->any()): ?>
                <div class="mb-2 p-3 rounded-2xl bg-rose-50 text-rose-800 border border-rose-200 shadow-sm text-sm">
                    <ul class="list-disc ml-5 space-y-0.5">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($err); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
        </div>

        
        <div class="px-4 lg:px-6 pb-10 pt-4">
            <?php echo $__env->yieldContent('content'); ?>
        </div>

        <?php echo $__env->yieldContent('scripts'); ?>

    </main>
</div>

<script>
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const openBtn = document.getElementById('openSidebar');

    function openSidebar() {
        sidebar.classList.remove('-translate-x-full');
        overlay.classList.remove('hidden');
    }
    function closeSidebar() {
        sidebar.classList.add('-translate-x-full');
        overlay.classList.add('hidden');
    }

    openBtn?.addEventListener('click', openSidebar);
    overlay?.addEventListener('click', closeSidebar);

    // Desktop collapse / expand
    const toggleSidebarBtn = document.getElementById('toggleSidebar');
    toggleSidebarBtn?.addEventListener('click', function () {
        document.body.classList.toggle('sidebar-collapsed');
    });
</script>

</body>
</html>
<?php /**PATH E:\softwares\26dec25Backup\resources\views/layouts/admin.blade.php ENDPATH**/ ?>