<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;

class AdminDashboardController extends Controller
{
    public function index()
    {
        $totalPatients   = User::where('role', 'patient')->count();
        $totalDoctors    = User::where('role', 'doctor')->count();
        $totalVolunteers = User::where('role', 'volunteer')->count();
        $totalSupport    = User::where('role', 'support')->count();
        $totalSeo        = User::where('role', 'seo')->count();

        // include support and seo in pending approvals
        $pendingApprovals = User::whereIn('role', ['patient', 'doctor', 'volunteer', 'support', 'seo'])
            ->where('is_approved', false)
            ->count();

        // You can also calculate "new today" etc if you want
        $newPatientsToday = User::where('role', 'patient')
            ->whereDate('created_at', today())
            ->count();

        $onlineDoctors = 0; // (placeholder unless you track online status)
        $activeCampaigns = 0; // placeholder

        return view('dashboards.admin', compact(
            'totalPatients',
            'totalDoctors',
            'totalVolunteers',
            'pendingApprovals',
            'newPatientsToday',
            'onlineDoctors',
            'activeCampaigns'
        ));
    }
}
