<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\PatientProfile;
use App\Models\DoctorProfile;
use App\Models\VolunteerProfile;
use Illuminate\Http\Request;

class AdminRegistrationApprovalController extends Controller
{
    public function index()
    {
        // include support and seo roles as they also require admin approval
        $pendingUsers = User::whereIn('role', ['patient', 'doctor', 'volunteer', 'support', 'seo'])
            ->where('is_approved', false)
            ->orderBy('created_at', 'desc')
            ->get();

        return view('admin.registrations.pending', compact('pendingUsers'));
    }

    public function approve(User $user)
    {
        if (!in_array($user->role, ['patient', 'doctor', 'volunteer', 'support', 'seo'])) {
            return back()->with('error', 'Only patient/doctor/volunteer/support/seo registrations can be approved here.');
        }

        $user->update([
            'is_approved' => true,
        ]);

        // TODO: Optionally send email: "Your account is approved"

        return back()->with('success', 'User approved successfully and can now log in.');
    }

    public function destroy(User $user)
    {
        if (!in_array($user->role, ['patient', 'doctor', 'volunteer', 'support', 'seo'])) {
            return back()->with('error', 'Only patient/doctor/volunteer/support/seo registrations can be deleted here.');
        }

        // Permanently delete related profiles where applicable
        if ($user->role === 'patient') {
            PatientProfile::where('user_id', $user->id)->delete();
        } elseif ($user->role === 'doctor') {
            DoctorProfile::where('user_id', $user->id)->delete();
        } elseif ($user->role === 'volunteer') {
            VolunteerProfile::where('user_id', $user->id)->delete();
        }

        $user->delete();

        return back()->with('success', 'Registration declined and data deleted permanently.');
    }
}
