<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;

class CategoryController extends Controller
{
    public function index(Request $request)
    {
        $query = Category::query();
        if ($q = $request->query('q')) {
            $query->where('name', 'like', "%{$q}%");
        }

        $categories = $query->orderBy('name')->paginate(30)->withQueryString();

        return view('admin.categories.index', compact('categories'));
    }

    public function create()
    {
        return view('admin.categories.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:191|unique:categories,name',
        ]);

        Category::create(['name' => $data['name']]);

        return redirect()->route('admin.categories.index')->with('success', 'Category created.');
    }

    public function edit(Category $team_category)
    {
        $category = $team_category;
        return view('admin.categories.edit', compact('category'));
    }

    public function update(Request $request, Category $team_category)
    {
        $data = $request->validate([
            'name' => 'required|string|max:191|unique:categories,name,' . $team_category->id,
        ]);

        $team_category->update(['name' => $data['name']]);

        return redirect()->route('admin.categories.index')->with('success', 'Category updated.');
    }

    public function destroy(Category $team_category)
    {
        $team_category->delete();
        return redirect()->route('admin.categories.index')->with('success', 'Category deleted.');
    }
}
