<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\MabSession;
use Illuminate\Http\Request;

class MabSessionController extends Controller
{
    public function index()
    {
        $sessions = MabSession::orderBy('created_at', 'desc')->get();
        return view('admin.mab_sessions.index', compact('sessions'));
    }

    public function create()
    {
        return view('admin.mab_sessions.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
        ]);

        MabSession::create([
            'title' => $request->title,
            'is_active' => $request->has('is_active'),
        ]);

        return redirect()->route('admin.mab-sessions.index')->with('success', 'Session created successfully.');
    }

    public function edit(MabSession $mabSession)
    {
        return view('admin.mab_sessions.edit', compact('mabSession'));
    }

    public function update(Request $request, MabSession $mabSession)
    {
        $request->validate([
            'title' => 'required|string|max:255',
        ]);

        $mabSession->update([
            'title' => $request->title,
            'is_active' => $request->has('is_active'),
        ]);

        return redirect()->route('admin.mab-sessions.index')->with('success', 'Session updated successfully.');
    }

    public function destroy(MabSession $mabSession)
    {
        $mabSession->delete();
        return redirect()->route('admin.mab-sessions.index')->with('success', 'Session deleted successfully.');
    }
}
