<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RegisterController extends Controller
{
    public function showRoleSelect()
    {
        return view('auth.register-role');
    }

    public function showPatientForm()
    {
        return view('auth.register-patient');
    }

    public function showDoctorForm()
    {
        return view('auth.register-doctor');
    }

    public function showVolunteerForm()
    {
        return view('auth.register-volunteer');
    }

    protected function createAndLoginUser(array $data, string $role)
    {
        $user = User::create([
            'name'     => $data['name'],
            'email'    => $data['email'],
            'phone'    => $data['phone'] ?? null,
            'password' => $data['password'], // auto-hashed by model
            'role'     => $role,
            'is_active'=> true,
        ]);

        Auth::login($user);

        return $user;
    }

    public function registerPatient(Request $request)
    {
        $data = $request->validate([
            'name'                  => ['required', 'string', 'max:255'],
            'email'                 => ['required', 'email', 'max:255', 'unique:users,email'],
            'phone'                 => ['nullable', 'string', 'max:20'],
            'password'              => ['required', 'string', 'min:8', 'confirmed'],
        ]);

        $user = $this->createAndLoginUser($data, User::ROLE_PATIENT);

        return redirect()->route('patient.dashboard')
            ->with('success', 'Welcome! Your patient account has been created.');
    }

    public function registerDoctor(Request $request)
    {
        $data = $request->validate([
            'name'                  => ['required', 'string', 'max:255'],
            'email'                 => ['required', 'email', 'max:255', 'unique:users,email'],
            'phone'                 => ['nullable', 'string', 'max:20'],
            'password'              => ['required', 'string', 'min:8', 'confirmed'],
        ]);

        $user = $this->createAndLoginUser($data, User::ROLE_DOCTOR);

        return redirect()->route('doctor.dashboard')
            ->with('success', 'Doctor account created. Please complete your profile later.');
    }

    public function registerVolunteer(Request $request)
    {
        $data = $request->validate([
            'name'                  => ['required', 'string', 'max:255'],
            'email'                 => ['required', 'email', 'max:255', 'unique:users,email'],
            'phone'                 => ['nullable', 'string', 'max:20'],
            'password'              => ['required', 'string', 'min:8', 'confirmed'],
        ]);

        $user = $this->createAndLoginUser($data, User::ROLE_VOLUNTEER);

        return redirect()->route('volunteer.dashboard')
            ->with('success', 'Thank you for joining as a volunteer.');
    }
}
