<?php

namespace App\Http\Controllers\Doctor;

use App\Http\Controllers\Controller;
use App\Models\Event;
use Carbon\Carbon;

class DoctorDashboardController extends Controller
{
    public function index()
    {
        $now = Carbon::now();

        $totalEvents     = Event::count();
        $upcomingEvents  = Event::where('start_datetime', '>', $now)->count();
        $pastEvents      = Event::where('end_datetime', '<', $now)->count();
        $publishedEvents = Event::where('is_published', true)->count();

        return view('dashboards.doctor', compact(
            'totalEvents',
            'upcomingEvents',
            'pastEvents',
            'publishedEvents'
        ));
    }
}
