<?php

namespace App\Http\Controllers;

use App\Models\Gallery;
use App\Models\SeoMetadatum;
use Illuminate\Http\Request;

class GalleryFrontendController extends Controller
{
    public function index()
    {
        // 1. Fetch metadata
        $seo = SeoMetadatum::where('route_name', 'gallery.public.index')->first();

        // 2. Fetch all active images
        $gallery = Gallery::where('is_active', true)
            ->orderBy('created_at', 'desc')
            ->get();

        return view('frontend.gallery.index', compact('gallery', 'seo'));
    }
}
