<?php

namespace App\Http\Controllers\Support;

use App\Http\Controllers\Controller;
use App\Models\TodoCategory;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = TodoCategory::orderBy('display_order')->paginate(20);
        return view('support.categories.index', compact('categories'));
    }

    public function create()
    {
        return view('support.categories.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255|unique:todo_categories,name',
            'description' => 'nullable|string',
            'display_order' => 'nullable|integer',
        ]);

        $data['created_by'] = auth()->id();

        TodoCategory::create($data);

        return redirect()->route('support.categories.index')->with('success', 'Category created.');
    }

    public function edit(TodoCategory $category)
    {
        return view('support.categories.edit', compact('category'));
    }

    public function update(Request $request, TodoCategory $category)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255|unique:todo_categories,name,' . $category->id,
            'description' => 'nullable|string',
            'display_order' => 'nullable|integer',
        ]);

        $category->update($data);

        return redirect()->route('support.categories.index')->with('success', 'Category updated.');
    }

    public function destroy(TodoCategory $category)
    {
        $category->delete();
        return redirect()->route('support.categories.index')->with('success', 'Category deleted.');
    }
}
