<?php

namespace App\Http\Controllers\Volunteer;

use App\Http\Controllers\Controller;
use App\Models\Event;

class VolunteerDashboardController extends Controller
{
    public function index()
    {
        $now = \Carbon\Carbon::now();

        $totalEvents     = Event::count();
        $upcomingEvents  = Event::where('start_datetime', '>', $now)->count();
        $pastEvents      = Event::where('end_datetime', '<', $now)->count();

        // Todos assigned to current volunteer
        $openTasksCount = \App\Models\Todo::assignedTo(auth()->id())
            ->whereIn('status', [\App\Models\Todo::STATUS_PENDING, \App\Models\Todo::STATUS_IN_PROGRESS, \App\Models\Todo::STATUS_BLOCKED])
            ->count();

        $recentAssigned = \App\Models\Todo::assignedTo(auth()->id())
            ->orderBy('due_date')
            ->take(5)
            ->get();

        return view('dashboards.volunteer', compact(
            'totalEvents',
            'upcomingEvents',
            'pastEvents',
            'openTasksCount',
            'recentAssigned'
        ));
    }
}
