<?php

namespace App\Http\Requests\Support;

use Illuminate\Foundation\Http\FormRequest;

class AssignTodoRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->role === \App\Models\User::ROLE_SUPPORT;
    }

    public function rules(): array
    {
        return [
            'assignees' => ['nullable','array'],
            'assignees.*' => ['exists:users,id'],
        ];
    }
}
