<?php

namespace App\Http\Requests\Support;

use Illuminate\Foundation\Http\FormRequest;

class StoreTodoRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->role === \App\Models\User::ROLE_SUPPORT;
    }

    public function rules(): array
    {
        return [
            'title' => ['required','string','max:255'],
            'description' => ['nullable','string'],
            'category_id' => ['nullable','exists:todo_categories,id'],
            'priority' => ['required','in:low,medium,high,urgent'],
            'due_date' => ['nullable','date'],
            'assignees' => ['nullable','array'],
            'assignees.*' => ['exists:users,id'],
        ];
    }
}
