<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DoctorProfile extends Model
{
    use HasFactory;

    protected $table = 'doctor_profiles';

    protected $fillable = [
        'user_id',
        'first_name',
        'last_name',
        'phone',
        'country',
        'state',
        'city',
        'specialization',
        'gender',
        'age',
        'clinic_name',
        'about',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
