<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PatientProfile extends Model
{
    protected $fillable = [
        'user_id',
        'relationship_role',
        'first_name',
        'last_name',
        'phone',
        'country',
        'state',
        'city',
        'disease_id',
        'gender',
        'age',
        'doctor_name',
        'about',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
