<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SeoMetadatum extends Model
{
    protected $table = 'seo_metadata';

    protected $fillable = [
        'route_name',
        'slug',
        'title',
        'description',
        'keywords',
        'h1_heading',
        'canonical_url',
        'robots',
        'schema_js',
        'change_frequency',
        'priority',
        'og_title',
        'og_description',
        'og_image',
        'og_type',
        'twitter_card',
        'twitter_title',
        'twitter_description',
        'twitter_image',
    ];

    protected $casts = [
        'schema_js' => 'array',
    ];

    // Smart Accessors with Fallbacks

    public function getOgTitleAttribute($value)
    {
        return $value ?: $this->title;
    }

    public function getOgDescriptionAttribute($value)
    {
        return $value ?: $this->description;
    }

    public function getTwitterTitleAttribute($value)
    {
        return $value ?: $this->og_title; // Fallback to OG, then Title
    }

    public function getTwitterDescriptionAttribute($value)
    {
        return $value ?: $this->og_description;
    }

    public function getTwitterImageAttribute($value)
    {
        return $value ?: $this->og_image;
    }
}
