<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TodoCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'display_order',
        'created_by',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function todos()
    {
        // Use explicit foreign key 'category_id' to match the migration
        return $this->hasMany(Todo::class, 'category_id');
    }

    // scoped relations for counts
    public function openTodos()
    {
        return $this->hasMany(Todo::class, 'category_id')->whereIn('status', [Todo::STATUS_PENDING, Todo::STATUS_IN_PROGRESS, Todo::STATUS_BLOCKED]);
    }

    public function completedTodos()
    {
        return $this->hasMany(Todo::class, 'category_id')->where('status', Todo::STATUS_COMPLETED);
    }
}
