<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TodoUpdate extends Model
{
    use HasFactory;

    protected $fillable = [
        'todo_id',
        'user_id',
        'type',
        'content',
        'progress',
        'attachments',
    ];

    protected $casts = [
        'attachments' => 'array',
    ];

    public function todo()
    {
        return $this->belongsTo(Todo::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
