<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class YoutubeVideo extends Model
{
    protected $fillable = [
        'youtube_id',
        'title',
        'language',     // 👈 added
        'meta',
        'is_featured',
        'is_published',
        'sort_order',
    ];

    protected $casts = [
        'is_featured'  => 'boolean',
        'is_published' => 'boolean',
    ];

    /**
     * Available Indian languages for playlist selection.
     */
    public static function languageOptions(): array
    {
        return [
            'Hindi',
            'English (India)',
            'Bengali',
            'Telugu',
            'Marathi',
            'Tamil',
            'Gujarati',
            'Kannada',
            'Malayalam',
            'Odia',
            'Punjabi',
            'Assamese',
            'Urdu',
            'Konkani',
            'Sindhi',
            'Kashmiri',
            'Dogri',
            'Manipuri',
            'Bodo',
            'Santhali',
            'Maithili',
        ];
    }
}
