<?php

namespace App\Notifications;

use App\Models\Todo;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\DatabaseMessage;
use Illuminate\Notifications\Messages\MailMessage;

class TodoAssignedNotification extends Notification
{
    use Queueable;

    protected $todo;

    public function __construct(Todo $todo)
    {
        $this->todo = $todo;
    }

    public function via($notifiable)
    {
        // in-app (database) notification by default
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        return [
            'todo_id' => $this->todo->id,
            'title' => $this->todo->title,
            'message' => 'You have been assigned a task',
            'priority' => $this->todo->priority,
        ];
    }

    // optional mail
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('New Task Assigned: ' . $this->todo->title)
            ->line('A new task has been assigned to you.')
            ->action('View Task', url('/volunteer/todos/' . $this->todo->id));
    }
}
