<?php

namespace App\Notifications;

use App\Models\Todo;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class TodoCompletedNotification extends Notification
{
    use Queueable;

    protected $todo;
    protected $completedBy;

    public function __construct(Todo $todo, User $completedBy)
    {
        $this->todo = $todo;
        $this->completedBy = $completedBy;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        return [
            'todo_id' => $this->todo->id,
            'title' => $this->todo->title,
            'message' => sprintf('%s marked the task as completed.', $this->completedBy->name),
            'completed_by_id' => $this->completedBy->id,
        ];
    }
}
