<?php

namespace App\Policies;

use App\Models\Todo;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class TodoPolicy
{
    use HandlesAuthorization;

    public function view(User $user, Todo $todo)
    {
        if ($user->role === User::ROLE_SUPPORT) {
            return true;
        }

        // Volunteer may view only if assigned
        if ($user->role === User::ROLE_VOLUNTEER) {
            return $todo->volunteers()->where('users.id', $user->id)->exists();
        }

        return false;
    }

    public function create(User $user)
    {
        return $user->role === User::ROLE_SUPPORT;
    }

    public function update(User $user, Todo $todo)
    {
        // Support can update any; volunteer only if assigned
        if ($user->role === User::ROLE_SUPPORT) {
            return true;
        }

        if ($user->role === User::ROLE_VOLUNTEER) {
            return $todo->volunteers()->where('users.id', $user->id)->exists();
        }

        return false;
    }

    public function assign(User $user, Todo $todo)
    {
        return $user->role === User::ROLE_SUPPORT;
    }

    public function delete(User $user, Todo $todo)
    {
        return $user->role === User::ROLE_SUPPORT;
    }
}
