<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        \Illuminate\Support\Facades\View::composer('layouts.app', function ($view) {
            $route = \Illuminate\Support\Facades\Route::currentRouteName();
            $seo = null;
            
            if ($route) {
                // Try exact match
                $seo = \App\Models\SeoMetadatum::where('route_name', $route)->first();
                
                // If not found, check if it's a "show" route with a slug parameter? 
                // For now, keep it simple: route key based.
            }
            
            $view->with('seo', $seo);
        });

        // Register Todo policy
        \Illuminate\Support\Facades\Gate::policy(\App\Models\Todo::class, \App\Policies\TodoPolicy::class);
    }
}
