<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('patient_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->enum('relationship_role', ['patient', 'family_member'])->default('patient');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('phone', 20); // better than bigInteger for phones
            $table->string('country');
            $table->string('state');
            $table->string('city');
            $table->unsignedBigInteger('disease_id');
            $table->enum('gender', ['male', 'female', 'other']);
            $table->unsignedTinyInteger('age');
            $table->string('doctor_name');
            $table->text('about');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('patient_profiles');
    }
};
