<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patient_stories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('condition')->nullable();
            $table->string('title'); 
            $table->string('slug')->unique(); 
            $table->string('image_path');
            $table->boolean('is_published')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patient_stories');
    }
};
