<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('seo_metadata', function (Blueprint $table) {
            $table->id();
            $table->string('route_name')->unique();
            
            // Core SEO
            $table->string('slug')->nullable()->comment('Custom URL slug/canonical path identifier');
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            $table->text('keywords')->nullable(); // Optional but kept for internal search
            $table->string('h1_heading')->nullable()->comment('Primary page heading');
            
            // Advanced SEO
            $table->string('canonical_url')->nullable()->comment('Full canonical URL override');
            $table->string('robots')->default('index, follow')->comment('Meta robots tag content');
            $table->json('schema_js')->nullable()->comment('Custom JSON-LD schema');
            
            // Sitemap
            $table->string('change_frequency')->default('weekly');
            $table->decimal('priority', 2, 1)->default(0.8);
            
            // Social Media (Open Graph)
            $table->string('og_title')->nullable();
            $table->text('og_description')->nullable();
            $table->string('og_image')->nullable();
            $table->string('og_type')->default('website');
            
            // Twitter Card
            $table->string('twitter_card')->default('summary_large_image');
            $table->string('twitter_title')->nullable();
            $table->text('twitter_description')->nullable();
            $table->string('twitter_image')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('seo_metadata');
    }
};
