<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('patient_stories', function (Blueprint $table) {
            $table->text('description')->nullable()->after('title');
            $table->integer('display_order')->default(0)->after('is_published');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('patient_stories', function (Blueprint $table) {
            $table->dropColumn(['description', 'display_order']);
        });
    }
};
