<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('description');
            $table->text('excerpt')->nullable();
            
            // Event details
            $table->string('event_type'); // Webinar, Support Group, Workshop, Conference, etc.
            $table->string('event_mode'); // Virtual, In-Person, Hybrid
            
            // Date and time
            $table->dateTime('start_datetime');
            $table->dateTime('end_datetime');
            $table->string('timezone')->default('Asia/Kolkata');
            
            // Location and links
            $table->string('location')->nullable();
            $table->string('meeting_link')->nullable();
            $table->string('registration_link')->nullable();
            
            // Additional info
            $table->integer('max_participants')->nullable();
            $table->string('image_path')->nullable();
            
            // Publishing and ordering
            $table->boolean('is_published')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->integer('display_order')->default(0);
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('events');
    }
};
