<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mab_sessions', function (Blueprint $table) {
            $table->id();
            $table->string('title'); // e.g., "2024-2025"
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        Schema::table('m_a_b_s', function (Blueprint $table) {
            $table->foreignId('mab_session_id')->nullable()->constrained('mab_sessions')->onDelete('cascade');
            $table->string('name')->nullable();
            $table->string('image')->nullable();
            $table->string('location')->nullable();
            $table->text('about')->nullable();
            $table->string('designation')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('m_a_b_s', function (Blueprint $table) {
            $table->dropForeign(['mab_session_id']);
            $table->dropColumn(['mab_session_id', 'name', 'image', 'location', 'about', 'designation']);
        });

        Schema::dropIfExists('mab_sessions');
    }
};
