<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('todo_updates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('todo_id')->constrained('todos')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->enum('type', ['comment', 'status', 'progress'])->default('comment');
            $table->text('content')->nullable();
            $table->unsignedTinyInteger('progress')->nullable();
            $table->json('attachments')->nullable();
            $table->timestamps();

            $table->index(['todo_id', 'user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('todo_updates');
    }
};