<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\PatientStory;
use Illuminate\Support\Str;

class PatientStorySeeder extends Seeder
{
    public function run(): void
    {
        $stories = [
            [
                'name'       => 'Anita',
                'condition'  => 'Dermatomyositis',
                'title'      => 'Long-time Friends Find Humor and Purpose in Difficult Journey',
                'slug'       => 'long-time-friends-difficult-journey',
                'image_path' => 'assets/images/pp1.jpg',
            ],
            [
                'name'       => 'Rajesh',
                'condition'  => 'Polymyositis',
                'title'      => 'A Story of Discovery and Success… So Far',
                'slug'       => 'story-of-discovery-and-success',
                'image_path' => 'assets/images/pp2.jpg',
            ],
            [
                'name'       => 'Meera',
                'condition'  => 'Caregiver',
                'title'      => 'My First MyoCon',
                'slug'       => 'my-first-myocon',
                'image_path' => 'assets/images/pp3.jpeg',
            ],
            [
                'name'       => 'Suman',
                'condition'  => 'Inclusion Body Myositis',
                'title'      => 'Pushing for an Answer',
                'slug'       => 'pushing-for-an-answer',
                'image_path' => 'assets/images/pp4.jpg',
            ],
        ];

        foreach ($stories as $data) {
            PatientStory::updateOrCreate(
                ['slug' => $data['slug']],
                $data
            );
        }
    }
}
