<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class SeoUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Ensure role exists if you are using a roles table, 
        // but assuming 'role' is just a column on users based on previous context.
        // Based on routes: middleware(['auth', 'role:seo']) implies a check.
        // Let's create the user.

        // Check if user exists first to avoid duplicates
        if (!User::where('email', 'seo@gmail.com')->exists()) {
            User::create([
                'name' => 'SEO Admin',
                'email' => 'seo@gmail.com',
                'password' => Hash::make('password'),
                'role' => 'seo', // Assuming 'role' column exists
            ]);
            $this->command->info('SEO User created: seo@gmail.com / password');
        } else {
            $this->command->info('SEO User already exists.');
        }
    }
}
