<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TodoCategory;

class TodoCategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            ['name' => 'Social Media', 'description' => 'Tasks for social platforms', 'display_order' => 1],
            ['name' => 'Content Creation', 'description' => 'Articles, blog posts, assets', 'display_order' => 2],
            ['name' => 'IT & Ops', 'description' => 'Technical tasks and support', 'display_order' => 3],
            ['name' => 'Outreach', 'description' => 'Volunteer outreach and coordination', 'display_order' => 4],
        ];

        foreach ($categories as $c) {
            TodoCategory::firstOrCreate(['name' => $c['name']], $c + ['created_by' => 1]);
        }
    }
}
