<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // Admin
        User::updateOrCreate(
            ['email' => 'admin@gmail.com'],
            [
                'name'     => 'Main Admin',
                'password' => Hash::make('password'),
                'role'     => 'admin',
                'is_approved' => true,
            ]
        );

        // SEO Admin
        User::updateOrCreate(
            ['email' => 'seo@gmail.com'],
            [
                'name'     => 'SEO Admin',
                'password' => Hash::make('password'),
                'role'     => 'seo',
                 'is_approved' => true,
            ]
        );

        // Test Patient
        User::updateOrCreate(
            ['email' => 'patient@gmail.com'],
            [
                'name'     => 'Test Patient',
                'password' => Hash::make('password'),
                'role'     => 'patient',
            ]
        );

        // Test Doctor
        User::updateOrCreate(
            ['email' => 'doctor@gmail.com'],
            [
                'name'     => 'Test Doctor',
                'password' => Hash::make('password'),
                'role'     => 'doctor',
            ]
        );

        // Test Volunteer
        User::updateOrCreate(
            ['email' => 'volunteer@gmail.com'],
            [
                'name'     => 'Test Volunteer',
                'password' => Hash::make('password'),
                'role'     => 'volunteer',
            ]
        );
         // Test Volunteer
        User::updateOrCreate(
            ['email' => 'support@gmail.com'],
            [
                'name'     => 'Test Support',
                'password' => Hash::make('password'),
                'role'     => 'support',
            ]
        );
    }
}
