# Todos / Task System (Support -> Volunteers)

Quick setup notes for development and deployment:

1. Run migrations:

   php artisan migrate

2. Seed default categories (optional):

   php artisan db:seed --class=Database\Seeders\TodoCategorySeeder

3. To enable queued notifications (recommended for production), configure queue driver and run workers:

   php artisan queue:work

4. Routes added:
   - Support: `/support/todos` (resource controller `Support\TodoController`)
   - Support categories: `/support/categories` (resource controller `Support\CategoryController`)
   - Volunteer: `/volunteer/todos` (list) and `/volunteer/todos/{todo}` (detail)

5. Notes:
   - Only users with role `support` can create/assign/update/delete todos.
   - Volunteers see assigned todos in their dashboard and can update status and add updates.
   - In-app notifications are created when assignees are assigned (database channel).

If you want, I can now:
- run the migrations locally and seed categories,
- add tests (unit & feature), and
- wire up email notifications for assignment (optional).
