<?php

require __DIR__.'/vendor/autoload.php';
$app = require __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$event = App\Models\Event::first();
if ($event) {
    $event->start_datetime = now()->addDays(2);
    $event->end_datetime = now()->addDays(2)->addHours(2);
    $event->save();
    echo "Updated Event ID {$event->id} to Start: {$event->start_datetime} | End: {$event->end_datetime}\n";
} else {
    echo "No event found to update.\n";
}

// Verify
$events = App\Models\Event::published()->upcoming()->get();
echo "Upcoming Events Count: " . $events->count() . "\n";
foreach ($events as $e) {
    echo " - " . $e->title . "\n";
}
