// Hero Section: Rotating Slides
document.addEventListener('DOMContentLoaded', function () {
    const slides = document.querySelectorAll('.hero-alt__slide');
    if (slides.length > 0) {
        let currentSlide = 0;

        function rotateSlides() {
            slides[currentSlide].classList.remove('is-active');
            currentSlide = (currentSlide + 1) % slides.length;
            slides[currentSlide].classList.add('is-active');
        }

        // Rotate every 4 seconds
        setInterval(rotateSlides, 4000);
    }

    // Brand Ambassador Section: Photo rotation (if exists)
    const baPhoto = document.getElementById('ba-photo');
    const baBadge = document.getElementById('ba-badge');

    if (baPhoto && baBadge) {
        const ambassadors = [
            {
                photo: '/assets/images/samantha-ruth-prabhu.webp',
                name: 'Samantha Ruth Prabhu',
                title: 'Brand Ambassador'
            }
            // Add more ambassadors here if needed
        ];

        let currentAmbassador = 0;

        function rotateAmbassador() {
            if (ambassadors.length <= 1) return;

            baPhoto.classList.add('is-fading');
            baBadge.classList.add('is-fading');

            setTimeout(() => {
                currentAmbassador = (currentAmbassador + 1) % ambassadors.length;
                const amb = ambassadors[currentAmbassador];

                baPhoto.src = amb.photo;
                baBadge.textContent = `${amb.name} • ${amb.title}`;

                baPhoto.classList.remove('is-fading');
                baBadge.classList.remove('is-fading');
            }, 500);
        }

        // Auto-rotate every 6 seconds
        setInterval(rotateAmbassador, 6000);

        // Manual controls (if they exist)
        const prevBtn = document.querySelector('[data-ba-prev]');
        const nextBtn = document.querySelector('[data-ba-next]');

        if (prevBtn) {
            prevBtn.addEventListener('click', () => {
                currentAmbassador = (currentAmbassador - 1 + ambassadors.length) % ambassadors.length;
                rotateAmbassador();
            });
        }

        if (nextBtn) {
            nextBtn.addEventListener('click', rotateAmbassador);
        }
    }
});
